/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.internal.http;

import alluxio.shaded.client.com.amazonaws.SdkClientException;
import alluxio.shaded.client.com.amazonaws.annotation.SdkInternalApi;
import alluxio.shaded.client.com.amazonaws.http.HttpResponse;
import alluxio.shaded.client.com.amazonaws.internal.http.ErrorCodeParser;
import alluxio.shaded.client.com.amazonaws.protocol.json.JsonContent;
import alluxio.shaded.client.com.amazonaws.util.IOUtils;
import alluxio.shaded.client.software.amazon.ionIonReader;
import alluxio.shaded.client.software.amazon.ionIonSystem;
import alluxio.shaded.client.software.amazon.ionIonType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class IonErrorCodeParser
implements ErrorCodeParser {
    private static final Log log = LogFactory.getLog(IonErrorCodeParser.class);
    private static final String TYPE_PREFIX = "aws-type:";
    private static final String X_AMZN_REQUEST_ID_HEADER = "x-amzn-RequestId";
    private final ionIonSystem ionSystem;

    public IonErrorCodeParser(ionIonSystem ionSystem) {
        this.ionSystem = ionSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String parseErrorCode(HttpResponse response, JsonContent jsonContents) {
        ionIonReader reader = this.ionSystem.newReader(jsonContents.getRawContent());
        try {
            String[] annotations;
            ionIonType type = reader.next();
            if (type != ionIonType.STRUCT) {
                throw new SdkClientException(String.format("Can only get error codes from structs (saw %s), request id %s", new Object[]{type, IonErrorCodeParser.getRequestId(response)}));
            }
            boolean errorCodeSeen = false;
            String errorCode = null;
            for (String annotation : annotations = reader.getTypeAnnotations()) {
                if (!annotation.startsWith(TYPE_PREFIX)) continue;
                if (errorCodeSeen) {
                    throw new SdkClientException(String.format("Multiple error code annotations found for request id %s", IonErrorCodeParser.getRequestId(response)));
                }
                errorCodeSeen = true;
                errorCode = annotation.substring(TYPE_PREFIX.length());
            }
            String[] stringArray = errorCode;
            return stringArray;
        }
        finally {
            IOUtils.closeQuietly(reader, log);
        }
    }

    private static String getRequestId(HttpResponse response) {
        return response.getHeaders().get(X_AMZN_REQUEST_ID_HEADER);
    }
}

