/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.concurrent.LockMode;
import alluxio.resource.LockResource;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RWLockResource
extends LockResource {
    private final ReentrantReadWriteLock mRwLock;

    public RWLockResource(ReentrantReadWriteLock rwLock, LockMode mode, boolean acquireLock, boolean useTryLock) {
        super(mode == LockMode.READ ? rwLock.readLock() : rwLock.writeLock(), acquireLock, useTryLock);
        this.mRwLock = rwLock;
    }

    public boolean downgrade() {
        if (!this.mRwLock.isWriteLocked()) {
            return false;
        }
        Preconditions.checkState(this.mRwLock.isWriteLockedByCurrentThread(), "Lock downgrades may only be initiated by the holding thread.");
        Preconditions.checkState(this.mLock == this.mRwLock.writeLock(), "mLock must be the same as mRwLock");
        this.mRwLock.readLock().lock();
        this.mLock.unlock();
        this.mLock = this.mRwLock.readLock();
        return true;
    }
}

