/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.selectionpolicy;

import alluxio.exception.status.UnavailableException;
import alluxio.master.MasterInquireClient;
import alluxio.master.selectionpolicy.AbstractMasterSelectionPolicy;
import alluxio.master.selectionpolicy.MasterSelectionPolicy;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;

public class SelectionPolicyAnyMaster
extends AbstractMasterSelectionPolicy {
    protected SelectionPolicyAnyMaster() {
    }

    @Override
    public synchronized InetSocketAddress getGrpcMasterAddress(MasterInquireClient masterInquireClient) throws UnavailableException {
        ArrayList<InetSocketAddress> masterAddresses = new ArrayList<InetSocketAddress>(masterInquireClient.getMasterRpcAddresses());
        if (masterAddresses.size() == 0) {
            throw new UnavailableException("No master available");
        }
        Collections.shuffle(masterAddresses);
        return (InetSocketAddress)masterAddresses.get(0);
    }

    @Override
    public MasterSelectionPolicy.Type getType() {
        return MasterSelectionPolicy.Type.ANY_MASTER;
    }
}

