/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.master.MasterInquireClient;
import alluxio.uri.Authority;
import alluxio.uri.SingleMasterAuthority;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SingleMasterInquireClient
implements MasterInquireClient {
    private final SingleMasterConnectDetails mConnectDetails;

    public SingleMasterInquireClient(InetSocketAddress address) {
        this.mConnectDetails = new SingleMasterConnectDetails(address);
    }

    @Override
    public InetSocketAddress getPrimaryRpcAddress() {
        return this.mConnectDetails.getAddress();
    }

    @Override
    public List<InetSocketAddress> getMasterRpcAddresses() {
        return Collections.singletonList(this.mConnectDetails.getAddress());
    }

    @Override
    public MasterInquireClient.ConnectDetails getConnectDetails() {
        return this.mConnectDetails;
    }

    public static class SingleMasterConnectDetails
    implements MasterInquireClient.ConnectDetails {
        private final InetSocketAddress mAddress;

        public SingleMasterConnectDetails(InetSocketAddress address) {
            this.mAddress = address;
        }

        public InetSocketAddress getAddress() {
            return this.mAddress;
        }

        @Override
        public Authority toAuthority() {
            return new SingleMasterAuthority(this.mAddress.getHostString(), this.mAddress.getPort());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SingleMasterConnectDetails)) {
                return false;
            }
            SingleMasterConnectDetails that = (SingleMasterConnectDetails)o;
            return this.mAddress.equals(that.mAddress);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.mAddress);
        }

        public String toString() {
            return this.toAuthority().toString();
        }
    }
}

