/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.grpc.LoadJobPOptions;
import alluxio.job.JobRequest;
import alluxio.shaded.client.com.fasterxml.jackson.annotation.JsonProperty;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LoadJobRequest
implements JobRequest {
    private static final String TYPE = "load";
    private static final long serialVersionUID = -4100882786127020489L;
    private final String mPath;
    private final LoadJobPOptions mOptions;

    public LoadJobRequest(@JsonProperty(value="path") String path, @JsonProperty(value="loadJobPOptions") LoadJobPOptions options) {
        this.mPath = Preconditions.checkNotNull(path, "The file path cannot be null");
        this.mOptions = Preconditions.checkNotNull(options, "The load job options cannot be null");
    }

    public String getPath() {
        return this.mPath;
    }

    public LoadJobPOptions getOptions() {
        return this.mOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Path", this.mPath).add("Options", this.mOptions).toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

