/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Reconfigurable;
import alluxio.conf.ReconfigurableRegistry;
import alluxio.heartbeat.HeartbeatContext;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatTimer;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Supplier;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.SecurityUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class HeartbeatThread
implements Runnable,
Reconfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatThread.class);
    private final String mThreadName;
    private final HeartbeatExecutor mExecutor;
    private final UserState mUserState;
    private final Supplier<Long> mIntervalSupplier;
    private HeartbeatTimer mTimer;
    private AlluxioConfiguration mConfiguration;
    private Status mStatus;

    @VisibleForTesting
    public static String generateThreadName(String executorName, String threadId) {
        if (threadId == null || threadId.isEmpty()) {
            return executorName;
        }
        return executorName + "-" + threadId;
    }

    public HeartbeatThread(String executorName, String threadId, HeartbeatExecutor executor, Supplier<Long> intervalSupplier, AlluxioConfiguration conf, UserState userState) {
        this.mThreadName = HeartbeatThread.generateThreadName(executorName, threadId);
        this.mExecutor = Preconditions.checkNotNull(executor, "executor");
        Class<? extends HeartbeatTimer> timerClass = HeartbeatContext.getTimerClass(executorName);
        this.mTimer = CommonUtils.createNewClassInstance(timerClass, new Class[]{String.class, Long.TYPE}, new Object[]{this.mThreadName, intervalSupplier.get()});
        this.mConfiguration = conf;
        this.mUserState = userState;
        this.mIntervalSupplier = intervalSupplier;
        this.mStatus = Status.INIT;
        ReconfigurableRegistry.register(this);
    }

    public HeartbeatThread(String executorName, HeartbeatExecutor executor, Supplier<Long> intervalSupplier, AlluxioConfiguration conf, UserState userState) {
        this(executorName, null, executor, intervalSupplier, conf, userState);
    }

    @Override
    public void run() {
        try {
            if (SecurityUtils.isSecurityEnabled(this.mConfiguration) && AuthenticatedClientUser.get(this.mConfiguration) == null) {
                AuthenticatedClientUser.set(this.mUserState.getUser().getName());
            }
        }
        catch (IOException e) {
            LOG.error("Failed to set AuthenticatedClientUser in HeartbeatThread.");
        }
        Thread.currentThread().setName(this.mThreadName);
        try {
            while (!Thread.interrupted()) {
                this.mStatus = Status.WAITING;
                this.mTimer.tick();
                this.mStatus = Status.RUNNING;
                this.mExecutor.heartbeat();
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            LOG.error("Uncaught exception in heartbeat executor, Heartbeat Thread shutting down", (Throwable)e);
        }
        finally {
            this.mStatus = Status.STOPPED;
            this.mExecutor.close();
        }
    }

    public void updateIntervalMs(long intervalMs) {
        this.mTimer.setIntervalMs(intervalMs);
    }

    public Status getStatus() {
        return this.mStatus;
    }

    @Override
    public void update() {
        if (this.mStatus == Status.STOPPED) {
            ReconfigurableRegistry.unregister(this);
            return;
        }
        long interval = this.mIntervalSupplier.get();
        if (interval != this.mTimer.getIntervalMs()) {
            this.updateIntervalMs(interval);
        }
    }

    public static enum Status {
        INIT,
        WAITING,
        RUNNING,
        STOPPED;

    }
}

