/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.util;

import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.TieredIdentityUtils;
import alluxio.util.network.NettyUtils;
import alluxio.wire.TieredIdentity;
import alluxio.wire.WorkerNetAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class BlockLocationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BlockLocationUtils.class);

    public static Optional<Pair<WorkerNetAddress, Boolean>> nearest(TieredIdentity tieredIdentity, List<WorkerNetAddress> addresses, AlluxioConfiguration conf) {
        Optional<TieredIdentity> nearestIdentity;
        if (conf.getBoolean(PropertyKey.WORKER_DATA_SERVER_DOMAIN_SOCKET_AS_UUID)) {
            for (WorkerNetAddress addr2 : addresses) {
                if (!NettyUtils.isDomainSocketAccessible(addr2, conf)) continue;
                LOG.debug("Found local worker by file system inspection of path {}", (Object)addr2.getDomainSocketPath());
                return Optional.of(new Pair<WorkerNetAddress, Boolean>(addr2, true));
            }
        }
        if (!(nearestIdentity = TieredIdentityUtils.nearest(tieredIdentity, addresses.stream().map(addr -> addr.getTieredIdentity()).collect(Collectors.toList()), conf)).isPresent()) {
            return Optional.empty();
        }
        boolean isLocal = tieredIdentity.getTier(0).getTierName().equals("node") && tieredIdentity.topTiersMatch(nearestIdentity.get());
        Optional<WorkerNetAddress> dataSource = addresses.stream().filter(addr -> addr.getTieredIdentity().equals(nearestIdentity.get())).findFirst();
        if (!dataSource.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new Pair<WorkerNetAddress, Boolean>(dataSource.get(), isLocal));
    }

    private BlockLocationUtils() {
    }
}

