/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.reflect.Method;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.weakref.jmx.MBeanAttribute;
import org.weakref.jmx.ReflectionUtils;

class ReflectionMBeanAttribute
implements MBeanAttribute {
    private final MBeanAttributeInfo info;
    private final Object target;
    private final String name;
    private final Method getter;
    private final Method setter;

    public ReflectionMBeanAttribute(MBeanAttributeInfo info, Object target, Method getter, Method setter) {
        if (info == null) {
            throw new NullPointerException("info is null");
        }
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        this.info = info;
        this.target = target;
        this.name = info.getName();
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public MBeanAttributeInfo getInfo() {
        return this.info;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.getter == null) {
            throw new AttributeNotFoundException(this.name + " is write-only");
        }
        Object result = ReflectionUtils.invoke(this.target, this.getter, new Object[0]);
        return result;
    }

    @Override
    public void setValue(Object value) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.setter == null) {
            throw new AttributeNotFoundException(this.name + " is read-only");
        }
        if (!ReflectionUtils.isAssignable(value, this.setter.getParameterTypes()[0])) {
            throw new InvalidAttributeValueException("Can not assign " + value.getClass() + " to attribute " + this.name);
        }
        ReflectionUtils.invoke(this.target, this.setter, value);
    }
}

