/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v1_11.HeaderSetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsAccess;
import javax.annotation.Nullable;

final class TracingRequestHandler
extends RequestHandler2 {
    static final HandlerContextKey<Context> CONTEXT = new HandlerContextKey(Context.class.getName());
    private final Instrumenter<Request<?>, Response<?>> requestInstrumenter;
    private final Instrumenter<Request<?>, Response<?>> consumerInstrumenter;

    TracingRequestHandler(Instrumenter<Request<?>, Response<?>> requestInstrumenter, Instrumenter<Request<?>, Response<?>> consumerInstrumenter) {
        this.requestInstrumenter = requestInstrumenter;
        this.consumerInstrumenter = consumerInstrumenter;
    }

    public void beforeRequest(Request<?> request) {
        if ("com.amazonaws.services.s3.model.GeneratePresignedUrlRequest".equals(request.getOriginalRequest().getClass().getName())) {
            return;
        }
        Context parentContext = Context.current();
        if (!this.requestInstrumenter.shouldStart(parentContext, request)) {
            return;
        }
        Context context = this.requestInstrumenter.start(parentContext, request);
        AwsXrayPropagator.getInstance().inject(context, request, (TextMapSetter)HeaderSetter.INSTANCE);
        request.addHandlerContext(CONTEXT, (Object)context);
    }

    @CanIgnoreReturnValue
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
        SqsAccess.beforeMarshalling(request);
        return request;
    }

    public void afterResponse(Request<?> request, Response<?> response) {
        SqsAccess.afterResponse(request, response, this.consumerInstrumenter);
        this.finish(request, response, null);
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
        this.finish(request, response, e);
    }

    private void finish(Request<?> request, Response<?> response, @Nullable Throwable error) {
        Context context = (Context)request.getHandlerContext(CONTEXT);
        if (context == null) {
            return;
        }
        request.addHandlerContext(CONTEXT, null);
        this.requestInstrumenter.end(context, request, response, error);
    }
}

