/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsParentContext;

final class SqsImpl {
    private SqsImpl() {
    }

    static boolean afterResponse(Request<?> request, Response<?> response, Instrumenter<Request<?>, Response<?>> consumerInstrumenter) {
        if (response.getAwsResponse() instanceof ReceiveMessageResult) {
            SqsImpl.afterConsumerResponse(request, response, consumerInstrumenter);
            return true;
        }
        return false;
    }

    private static void afterConsumerResponse(Request<?> request, Response<?> response, Instrumenter<Request<?>, Response<?>> consumerInstrumenter) {
        ReceiveMessageResult receiveMessageResult = (ReceiveMessageResult)response.getAwsResponse();
        for (Message message : receiveMessageResult.getMessages()) {
            SqsImpl.createConsumerSpan(message, request, response, consumerInstrumenter);
        }
    }

    private static void createConsumerSpan(Message message, Request<?> request, Response<?> response, Instrumenter<Request<?>, Response<?>> consumerInstrumenter) {
        Context parentContext = SqsParentContext.ofSystemAttributes(message.getAttributes());
        Context context = consumerInstrumenter.start(parentContext, request);
        consumerInstrumenter.end(context, request, response, null);
    }

    static boolean beforeMarshalling(AmazonWebServiceRequest rawRequest) {
        if (rawRequest instanceof ReceiveMessageRequest) {
            ReceiveMessageRequest request = (ReceiveMessageRequest)rawRequest;
            if (!request.getAttributeNames().contains("AWSTraceHeader")) {
                request.withAttributeNames(new String[]{"AWSTraceHeader"});
            }
            return true;
        }
        return false;
    }

    static {
        String string = AmazonSQS.class.getName();
    }
}

