/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.orc.OrcOutputBuffer;
import io.trino.orc.checkpoint.DoubleStreamCheckpoint;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.Stream;
import io.trino.orc.stream.StreamDataOutput;
import io.trino.orc.stream.ValueOutputStream;
import java.util.ArrayList;
import java.util.List;

public class DoubleOutputStream
implements ValueOutputStream<DoubleStreamCheckpoint> {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DoubleOutputStream.class);
    private final OrcOutputBuffer buffer;
    private final List<DoubleStreamCheckpoint> checkpoints = new ArrayList<DoubleStreamCheckpoint>();
    private boolean closed;

    public DoubleOutputStream(CompressionKind compression, int bufferSize) {
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
    }

    public void writeDouble(double value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.buffer.writeDouble(value);
    }

    @Override
    public void close() {
        this.closed = true;
        this.buffer.close();
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new DoubleStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public List<DoubleStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(OrcColumnId columnId) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(columnId, Stream.StreamKind.DATA, Math.toIntExact(this.buffer.getOutputDataSize()), false));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

