/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.orc.metadata.statistics.BloomFilterBuilder;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.NoOpBloomFilterBuilder;
import io.trino.orc.metadata.statistics.SliceColumnStatisticsBuilder;
import io.trino.orc.metadata.statistics.StringStatistics;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StringStatisticsBuilder
implements SliceColumnStatisticsBuilder {
    private final int stringStatisticsLimitInBytes;
    private long nonNullValueCount;
    private Slice minimum;
    private Slice maximum;
    private long sum;
    private final BloomFilterBuilder bloomFilterBuilder;
    private final boolean shouldCompactMinMax;

    public StringStatisticsBuilder(int stringStatisticsLimitInBytes, BloomFilterBuilder bloomFilterBuilder) {
        this(stringStatisticsLimitInBytes, 0L, null, null, 0L, bloomFilterBuilder, true);
    }

    public StringStatisticsBuilder(int stringStatisticsLimitInBytes, BloomFilterBuilder bloomFilterBuilder, boolean shouldCompactMinMax) {
        this(stringStatisticsLimitInBytes, 0L, null, null, 0L, bloomFilterBuilder, shouldCompactMinMax);
    }

    private StringStatisticsBuilder(int stringStatisticsLimitInBytes, long nonNullValueCount, Slice minimum, Slice maximum, long sum, BloomFilterBuilder bloomFilterBuilder, boolean shouldCompactMinMax) {
        this.stringStatisticsLimitInBytes = stringStatisticsLimitInBytes;
        this.nonNullValueCount = nonNullValueCount;
        this.minimum = minimum;
        this.maximum = maximum;
        this.sum = sum;
        this.bloomFilterBuilder = Objects.requireNonNull(bloomFilterBuilder, "bloomFilterBuilder");
        this.shouldCompactMinMax = shouldCompactMinMax;
    }

    public long getNonNullValueCount() {
        return this.nonNullValueCount;
    }

    @Override
    public void addValue(Slice value) {
        Objects.requireNonNull(value, "value is null");
        if (this.nonNullValueCount == 0L) {
            Preconditions.checkState((this.minimum == null && this.maximum == null ? 1 : 0) != 0);
            this.minimum = value;
            this.maximum = value;
        } else if (this.minimum != null && value.compareTo(this.minimum) <= 0) {
            this.minimum = value;
        } else if (this.maximum != null && value.compareTo(this.maximum) >= 0) {
            this.maximum = value;
        }
        this.bloomFilterBuilder.addString(value);
        ++this.nonNullValueCount;
        this.sum = Math.addExact(this.sum, (long)value.length());
    }

    private void addStringStatistics(long valueCount, StringStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((valueCount > 0L ? 1 : 0) != 0, (Object)"valueCount is 0");
        Preconditions.checkArgument((value.getMin() != null || value.getMax() != null ? 1 : 0) != 0, (Object)"min and max cannot both be null");
        if (this.nonNullValueCount == 0L) {
            Preconditions.checkState((this.minimum == null && this.maximum == null ? 1 : 0) != 0);
            this.minimum = value.getMin();
            this.maximum = value.getMax();
        } else {
            if (this.minimum != null && (value.getMin() == null || this.minimum.compareTo(value.getMin()) > 0)) {
                this.minimum = value.getMin();
            }
            if (this.maximum != null && (value.getMax() == null || this.maximum.compareTo(value.getMax()) < 0)) {
                this.maximum = value.getMax();
            }
        }
        this.nonNullValueCount += valueCount;
        this.sum = Math.addExact(this.sum, value.getSum());
    }

    private Optional<StringStatistics> buildStringStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        this.minimum = this.computeStringMinMax(this.minimum, true);
        this.maximum = this.computeStringMinMax(this.maximum, false);
        if (this.minimum == null && this.maximum == null) {
            return Optional.empty();
        }
        return Optional.of(new StringStatistics(this.minimum, this.maximum, this.sum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<StringStatistics> stringStatistics = this.buildStringStatistics();
        stringStatistics.ifPresent(s -> Verify.verify((this.nonNullValueCount > 0L ? 1 : 0) != 0));
        return new ColumnStatistics(this.nonNullValueCount, stringStatistics.map(s -> 5L + this.sum / this.nonNullValueCount).orElse(0L), null, null, null, null, stringStatistics.orElse(null), null, null, null, null, this.bloomFilterBuilder.buildBloomFilter());
    }

    public static Optional<StringStatistics> mergeStringStatistics(List<ColumnStatistics> stats) {
        StringStatisticsBuilder stringStatisticsBuilder = new StringStatisticsBuilder(Integer.MAX_VALUE, new NoOpBloomFilterBuilder());
        for (ColumnStatistics columnStatistics : stats) {
            StringStatistics partialStatistics = columnStatistics.getStringStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null || partialStatistics.getMin() == null && partialStatistics.getMax() == null) {
                return Optional.empty();
            }
            stringStatisticsBuilder.addStringStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return stringStatisticsBuilder.buildStringStatistics();
    }

    private Slice computeStringMinMax(Slice minOrMax, boolean isMin) {
        if (minOrMax == null || !this.shouldCompactMinMax && minOrMax.length() > this.stringStatisticsLimitInBytes) {
            return null;
        }
        if (minOrMax.length() > this.stringStatisticsLimitInBytes) {
            if (isMin) {
                return StringCompactor.truncateMin(minOrMax, this.stringStatisticsLimitInBytes);
            }
            return StringCompactor.truncateMax(minOrMax, this.stringStatisticsLimitInBytes);
        }
        if (minOrMax.isCompact()) {
            return minOrMax;
        }
        return minOrMax.copy();
    }

    static final class StringCompactor {
        private static final int INDEX_NOT_FOUND = -1;

        private StringCompactor() {
        }

        public static Slice truncateMin(Slice slice, int maxBytes) {
            Preconditions.checkArgument((slice.length() > maxBytes ? 1 : 0) != 0);
            int lastIndex = StringCompactor.findLastCharacterInRange(slice, maxBytes);
            if (lastIndex == -1) {
                return Slices.EMPTY_SLICE;
            }
            return slice.slice(0, lastIndex);
        }

        public static Slice truncateMax(Slice slice, int maxBytes) {
            int firstRemovedCharacterIndex = StringCompactor.findLastCharacterInRange(slice, maxBytes);
            int lastRetainedCharacterIndex = StringCompactor.findLastCharacterInRange(slice, firstRemovedCharacterIndex - 1);
            if (firstRemovedCharacterIndex == -1 || lastRetainedCharacterIndex == -1) {
                return Slices.EMPTY_SLICE;
            }
            int lastRetainedCharacter = SliceUtf8.getCodePointAt((Slice)slice, (int)lastRetainedCharacterIndex);
            while (lastRetainedCharacter == 0x10FFFF && lastRetainedCharacterIndex > 0) {
                if ((lastRetainedCharacterIndex = StringCompactor.findLastCharacterInRange(slice, lastRetainedCharacterIndex - 1)) == -1) {
                    return Slices.EMPTY_SLICE;
                }
                lastRetainedCharacter = SliceUtf8.getCodePointAt((Slice)slice, (int)lastRetainedCharacterIndex);
            }
            if (lastRetainedCharacterIndex == 0 && lastRetainedCharacter == 0x10FFFF) {
                return Slices.EMPTY_SLICE;
            }
            Slice sliceToAppend = SliceUtf8.codePointToUtf8((int)(++lastRetainedCharacter));
            byte[] result = new byte[lastRetainedCharacterIndex + sliceToAppend.length()];
            System.arraycopy(slice.byteArray(), slice.byteArrayOffset(), result, 0, lastRetainedCharacterIndex);
            System.arraycopy(sliceToAppend.byteArray(), 0, result, lastRetainedCharacterIndex, sliceToAppend.length());
            return Slices.wrappedBuffer((byte[])result);
        }

        private static int findLastCharacterInRange(Slice slice, int toInclusive) {
            for (int pos = toInclusive; pos >= 0; --pos) {
                if (!StringCompactor.isUtfBlockStartChar(slice.getByte(pos))) continue;
                return pos;
            }
            return -1;
        }

        private static boolean isUtfBlockStartChar(byte b) {
            return (b & 0xC0) != 128;
        }
    }
}

