/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import com.google.common.base.Preconditions;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.DecimalStatistics;
import io.trino.orc.metadata.statistics.StatisticsBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LongDecimalStatisticsBuilder
implements StatisticsBuilder {
    public static final long LONG_DECIMAL_VALUE_BYTES = 16L;
    private long nonNullValueCount;
    private BigDecimal minimum;
    private BigDecimal maximum;

    @Override
    public void addBlock(Type type, Block block) {
        int scale = ((DecimalType)type).getScale();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            Int128 value = (Int128)type.getObject(block, position);
            this.addValue(new BigDecimal(value.toBigInteger(), scale));
        }
    }

    public void addValue(BigDecimal value) {
        Objects.requireNonNull(value, "value is null");
        ++this.nonNullValueCount;
        if (this.minimum == null) {
            this.minimum = value;
            this.maximum = value;
        } else {
            this.minimum = this.minimum.min(value);
            this.maximum = this.maximum.max(value);
        }
    }

    private void addDecimalStatistics(long valueCount, DecimalStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        if (this.minimum == null) {
            this.minimum = value.getMin();
            this.maximum = value.getMax();
        } else {
            this.minimum = this.minimum.min(value.getMin());
            this.maximum = this.maximum.max(value.getMax());
        }
    }

    private Optional<DecimalStatistics> buildDecimalStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        Preconditions.checkState((this.minimum != null && this.maximum != null ? 1 : 0) != 0);
        return Optional.of(new DecimalStatistics(this.minimum, this.maximum, 16L));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<DecimalStatistics> decimalStatistics = this.buildDecimalStatistics();
        return new ColumnStatistics(this.nonNullValueCount, decimalStatistics.map(s -> 17L).orElse(0L), null, null, null, null, null, null, null, decimalStatistics.orElse(null), null, null);
    }

    public static Optional<DecimalStatistics> mergeDecimalStatistics(List<ColumnStatistics> stats) {
        LongDecimalStatisticsBuilder decimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            DecimalStatistics partialStatistics = columnStatistics.getDecimalStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            decimalStatisticsBuilder.addDecimalStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return decimalStatisticsBuilder.buildDecimalStatistics();
    }
}

