/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.trino.orc.DiskRange;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.stream.MemoryOrcDataReader;
import io.trino.orc.stream.OrcDataReader;
import java.util.Map;
import java.util.Objects;

public class MemoryOrcDataSource
implements OrcDataSource {
    private final OrcDataSourceId id;
    private final Slice data;
    private long readBytes;

    public MemoryOrcDataSource(OrcDataSourceId id, Slice data) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.data = Objects.requireNonNull(data, "data is null");
    }

    @Override
    public OrcDataSourceId getId() {
        return this.id;
    }

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getReadTimeNanos() {
        return 0L;
    }

    @Override
    public final long getEstimatedSize() {
        return this.data.length();
    }

    @Override
    public long getRetainedSize() {
        return this.data.getRetainedSize();
    }

    @Override
    public Slice readTail(int length) {
        int readSize = Math.min(this.data.length(), length);
        return this.readFully(this.data.length() - readSize, readSize);
    }

    @Override
    public final Slice readFully(long position, int length) {
        this.readBytes += (long)length;
        return this.data.slice(Math.toIntExact(position), length);
    }

    @Override
    public final <K> Map<K, OrcDataReader> readFully(Map<K, DiskRange> diskRanges) {
        Objects.requireNonNull(diskRanges, "diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            Slice slice = this.readFully(diskRange.getOffset(), diskRange.getLength());
            slices.put(entry.getKey(), (Object)new MemoryOrcDataReader(this.id, slice, 0L));
        }
        return slices.buildOrThrow();
    }

    public final String toString() {
        return this.id.toString();
    }
}

