/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.shaded.jmx.guice;

import com.google.shaded.shaded.inject.Inject;
import com.google.shaded.shaded.inject.Injector;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.weakref.shaded.jmx.MBeanExporter;
import org.weakref.shaded.jmx.guice.MapMapping;
import org.weakref.shaded.jmx.guice.Mapping;
import org.weakref.shaded.jmx.guice.ObjectNameFunction;
import org.weakref.shaded.jmx.guice.SetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GuiceMBeanExporter {
    @Inject
    public GuiceMBeanExporter(Set<Mapping> mappings, Set<SetMapping<?>> setMappings, Set<MapMapping<?, ?>> mapMappings, MBeanExporter exporter, Injector injector) {
        this.export(mappings, exporter, injector);
        this.exportSets(setMappings, exporter, injector);
        this.exportMaps(mapMappings, exporter, injector);
    }

    private <K, V> void exportMaps(Set<MapMapping<K, V>> mapMappings, MBeanExporter exporter, Injector injector) {
        for (MapMapping<K, V> mapping : mapMappings) {
            ObjectNameFunction<Map.Entry<K, V>> namingFunction = mapping.getObjectNameFunction();
            Map map = (Map)injector.getInstance(mapping.getKey());
            for (Map.Entry entry : map.entrySet()) {
                ObjectName name = namingFunction.name(entry);
                exporter.export(name, entry.getValue());
            }
        }
    }

    private <T> void exportSets(Set<SetMapping<T>> setMappings, MBeanExporter exporter, Injector injector) {
        for (SetMapping<T> mapping : setMappings) {
            ObjectNameFunction objectNameFunction = mapping.getObjectNameFunction();
            Set set = (Set)injector.getInstance(mapping.getKey());
            for (Object instance : set) {
                ObjectName name = objectNameFunction.name(instance);
                exporter.export(name, instance);
            }
        }
    }

    private void export(Set<Mapping> mappings, MBeanExporter exporter, Injector injector) {
        for (Mapping mapping : mappings) {
            exporter.export(mapping.getName(), injector.getInstance(mapping.getKey()));
        }
    }
}

