/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.hadoop2;

import com.google.shaded.common.shaded.reflect.TypeToken;
import com.google.shaded.gson.Gson;
import com.google.shaded.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class Hadoop2ClusterManagerUtil {
    static String addressConf = "yarn.resourcemanager.webapp.address";
    static String localHostAddress = "localhost:8088";
    static Log log = LogFactory.getLog(Hadoop2ClusterManagerUtil.class);

    private Hadoop2ClusterManagerUtil() {
    }

    public static URL getNodeURL(YarnConfiguration yConf) throws MalformedURLException {
        String address = yConf.get(addressConf, localHostAddress);
        String serverAddress = address.substring(0, address.indexOf(":"));
        int serverPort = Integer.parseInt(address.substring(address.indexOf(":") + 1));
        return new URL("http://" + serverAddress + ":" + serverPort + "/ws/v1/cluster/nodes");
    }

    public static List<Node> getAllNodes(YarnConfiguration yConf) throws Exception {
        BufferedReader in;
        ArrayList<Node> allNodes = new ArrayList();
        StringBuffer response = new StringBuffer();
        URL obj = Hadoop2ClusterManagerUtil.getNodeURL(yConf);
        HttpURLConnection httpcon = (HttpURLConnection)obj.openConnection();
        httpcon.setRequestMethod("GET");
        log.debug((Object)("Sending 'GET' request to URL: " + obj.toString()));
        int responseCode = httpcon.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(httpcon.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        } else {
            log.info((Object)("/ws/v1/cluster/nodes failed due to " + responseCode + ". Setting this node as worker."));
            httpcon.disconnect();
            return null;
        }
        in.close();
        httpcon.disconnect();
        Gson gson = new Gson();
        Type type = new TypeToken<NodesResponse>(){}.getType();
        NodesResponse nodesResponse = (NodesResponse)gson.fromJson(response.toString(), type);
        allNodes = nodesResponse.getNodes().getNodeList();
        return allNodes;
    }

    public static class Node {
        String nodeHostName;
        String state;

        public Node() {
        }

        public Node(String nodeHostName, String state) {
            this.nodeHostName = nodeHostName;
            this.state = state;
        }

        String getState() {
            return this.state;
        }

        String getNodeHostName() {
            return this.nodeHostName;
        }
    }

    public static class Nodes {
        @SerializedName(value="node")
        private List<Node> nodeList;

        public Nodes() {
        }

        public Nodes(List<Node> nodeStats) {
            this.nodeList = nodeStats;
        }

        public List<Node> getNodeList() {
            return this.nodeList;
        }

        public void setNodeList(List<Node> nodeStats) {
            this.nodeList = nodeStats;
        }
    }

    public static class NodesResponse {
        @SerializedName(value="nodes")
        private Nodes nodes;

        public NodesResponse() {
        }

        public NodesResponse(Nodes nodes) {
            this.nodes = nodes;
        }

        public Nodes getNodes() {
            return this.nodes;
        }

        public void setNodes(Nodes nodes) {
            this.nodes = nodes;
        }
    }
}

