/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper.utils;

import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class ShellExec {
    private List<String> args;

    public ShellExec(String cmd) {
        this.args = Arrays.asList("/bin/bash", "-c", cmd);
    }

    public CommandResult runCmd() throws IOException {
        Preconditions.checkNotNull(this.args);
        Preconditions.checkArgument(this.args.size() > 0);
        CommandResult cr = new CommandResult();
        Process p = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(this.args);
            p = pb.start();
        }
        catch (IOException e) {
            cr.setExitValue(1);
            cr.setErr("unable to start process");
            throw e;
        }
        ThreadedStreamHandler out = new ThreadedStreamHandler(p.getInputStream());
        ThreadedStreamHandler err = new ThreadedStreamHandler(p.getErrorStream());
        out.start();
        err.start();
        int exitVal = 1;
        while (true) {
            try {
                exitVal = p.waitFor();
                out.join();
                err.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        cr.setExitValue(exitVal);
        cr.setOut(out.toString());
        cr.setErr(err.toString());
        return cr;
    }

    public static class ThreadedStreamHandler
    extends Thread {
        private InputStream is;
        private String str;

        public ThreadedStreamHandler(InputStream is) {
            this.is = is;
            this.setDaemon(true);
        }

        private void close() {
            try {
                this.is.close();
            }
            catch (IOException e) {
                this.str = "unable to close " + e.getMessage();
            }
        }

        @Override
        public void run() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                ByteStreams.copy(this.is, ps);
                this.str = baos.toString();
            }
            catch (IOException e) {
                this.str = e.toString();
            }
            finally {
                this.close();
            }
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static class CommandResult {
        private int exitValue;
        private String out;
        private String err;

        public int getExitValue() {
            return this.exitValue;
        }

        public void setExitValue(int exitValue) {
            this.exitValue = exitValue;
        }

        public String getOut() {
            return this.out;
        }

        public void setOut(String out) {
            this.out = out;
        }

        public String getErr() {
            return this.err;
        }

        public void setErr(String err) {
            this.err = err;
        }
    }
}

