/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.manager;

import com.google.common.base.Verify;
import com.google.common.collect.Streams;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.manager.HdfsClassLoader;
import io.trino.spi.NodeManager;
import io.trino.spi.Plugin;
import io.trino.spi.classloader.ThreadContextClassLoader;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class HdfsFileSystemLoader {
    private final HdfsClassLoader classLoader;
    private final Object manager;

    public HdfsFileSystemLoader(Map<String, String> config, boolean azureEnabled, boolean gcsEnabled, boolean s3Enabled, String catalogName, NodeManager nodeManager, OpenTelemetry openTelemetry) {
        Class<?> clazz = this.tryLoadExistingHdfsManager();
        if (!this.getClass().getClassLoader().equals(Plugin.class.getClassLoader())) {
            File directory;
            Verify.verify((clazz == null ? 1 : 0) != 0, (String)"HDFS should not be on the plugin classpath", (Object[])new Object[0]);
            File sourceFile = this.getCurrentClassLocation();
            if (sourceFile.isDirectory()) {
                Verify.verify((boolean)sourceFile.getPath().endsWith("/target/classes"), (String)"Source file not in 'target' directory: %s", (Object)sourceFile);
                directory = new File(sourceFile.getParentFile().getParentFile().getParentFile(), "trino-hdfs/target/hdfs");
            } else {
                directory = new File(sourceFile.getParentFile(), "hdfs");
            }
            Verify.verify((boolean)directory.isDirectory(), (String)"HDFS directory is missing: %s", (Object)directory);
            this.classLoader = HdfsFileSystemLoader.createClassLoader(directory);
            clazz = HdfsFileSystemLoader.loadHdfsManager(this.classLoader);
        } else {
            Verify.verify((clazz != null ? 1 : 0) != 0, (String)"HDFS should be on the classpath for tests", (Object[])new Object[0]);
            this.classLoader = null;
        }
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)this.classLoader);){
            this.manager = clazz.getConstructor(Map.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, NodeManager.class, OpenTelemetry.class).newInstance(config, azureEnabled, gcsEnabled, s3Enabled, catalogName, nodeManager, openTelemetry);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> configure() {
        Set set;
        ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)this.classLoader);
        try {
            set = (Set)this.manager.getClass().getMethod("configure", new Class[0]).invoke(this.manager, new Object[0]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to configure HDFS:\n%s\n%s\n%s".formatted("<".repeat(70), e.getCause(), ">".repeat(70)), e);
            }
        }
        ignored.close();
        return set;
    }

    public TrinoFileSystemFactory create() {
        TrinoFileSystemFactory trinoFileSystemFactory;
        ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)this.classLoader);
        try {
            trinoFileSystemFactory = (TrinoFileSystemFactory)this.manager.getClass().getMethod("create", new Class[0]).invoke(this.manager, new Object[0]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        ignored.close();
        return trinoFileSystemFactory;
    }

    @PreDestroy
    public void stop() throws IOException, ReflectiveOperationException {
        try (HdfsClassLoader hdfsClassLoader = this.classLoader;
             ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)this.classLoader);){
            this.manager.getClass().getMethod("stop", new Class[0]).invoke(this.manager, new Object[0]);
        }
    }

    private File getCurrentClassLocation() {
        try {
            return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> tryLoadExistingHdfsManager() {
        try {
            return HdfsFileSystemLoader.loadHdfsManager(this.getClass().getClassLoader());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static Class<?> loadHdfsManager(ClassLoader classLoader) {
        try {
            return classLoader.loadClass("io.trino.filesystem.hdfs.HdfsFileSystemManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static HdfsClassLoader createClassLoader(File path) {
        List<URL> urls = HdfsFileSystemLoader.buildClassPath(path);
        Verify.verify((!urls.isEmpty() ? 1 : 0) != 0, (String)"HDFS directory is empty: %s", (Object)path);
        return new HdfsClassLoader(urls);
    }

    private static List<URL> buildClassPath(File path) {
        List<URL> list;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path.toPath());
            try {
                list = Streams.stream(directoryStream).map(Path::toFile).sorted().toList().stream().map(HdfsFileSystemLoader::fileToUrl).toList();
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }
}

