/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.manager;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;

final class HdfsClassLoader
extends URLClassLoader {
    public HdfsClassLoader(List<URL> urls) {
        super((URL[])urls.toArray(URL[]::new), HdfsClassLoader.getPlatformClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cachedClass = this.findLoadedClass(name);
            if (cachedClass != null) {
                return this.resolveClass(cachedClass, resolve);
            }
            if (HdfsClassLoader.isOverrideClass(name)) {
                return this.resolveClass(this.overrideClassLoader().loadClass(name), resolve);
            }
            return super.loadClass(name, resolve);
        }
    }

    private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        if (HdfsClassLoader.isOverrideResource(name)) {
            return this.overrideClassLoader().getResource(name);
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (HdfsClassLoader.isOverrideResource(name)) {
            return this.overrideClassLoader().getResources(name);
        }
        return super.getResources(name);
    }

    private ClassLoader overrideClassLoader() {
        return this.getClass().getClassLoader();
    }

    private static boolean isOverrideResource(String name) {
        return HdfsClassLoader.isOverrideClass(name.replace('.', '/'));
    }

    private static boolean isOverrideClass(String name) {
        return HdfsClassLoader.hasPackage(name, "io.trino.spi.") || HdfsClassLoader.hasPackage(name, "com.fasterxml.jackson.annotation.") || HdfsClassLoader.hasPackage(name, "io.airlift.slice.") || HdfsClassLoader.hasPackage(name, "org.openjdk.jol.") || HdfsClassLoader.hasPackage(name, "io.opentelemetry.api.") || HdfsClassLoader.hasPackage(name, "io.opentelemetry.context.") || HdfsClassLoader.hasPackage(name, "com.google.common.") || HdfsClassLoader.hasExactPackage(name, "io.trino.memory.context.") || HdfsClassLoader.hasExactPackage(name, "io.trino.filesystem.");
    }

    private static boolean hasPackage(String name, String packageName) {
        Preconditions.checkArgument((!packageName.isEmpty() && packageName.charAt(packageName.length() - 1) == '.' ? 1 : 0) != 0);
        return name.startsWith(packageName);
    }

    private static boolean hasExactPackage(String name, String packageName) {
        Preconditions.checkArgument((!packageName.isEmpty() && packageName.charAt(packageName.length() - 1) == '.' ? 1 : 0) != 0);
        return name.startsWith(packageName) && name.lastIndexOf(46) == packageName.length() - 1;
    }
}

