/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.security.AnySchemaPermissionsRule;
import io.trino.spi.connector.SchemaRoutineName;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class ProcedureAccessControlRule {
    private final Set<ProcedurePrivilege> privileges;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> roleRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> schemaRegex;
    private final Optional<Pattern> procedureRegex;

    @JsonCreator
    public ProcedureAccessControlRule(@JsonProperty(value="privileges") Set<ProcedurePrivilege> privileges, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="role") Optional<Pattern> roleRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="procedure") Optional<Pattern> procedureRegex) {
        this.privileges = ImmutableSet.copyOf((Collection)Objects.requireNonNull(privileges, "privileges is null"));
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.roleRegex = Objects.requireNonNull(roleRegex, "roleRegex is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "groupRegex is null");
        this.schemaRegex = Objects.requireNonNull(schemaRegex, "schemaRegex is null");
        this.procedureRegex = Objects.requireNonNull(procedureRegex, "procedureRegex is null");
    }

    public boolean matches(String user, Set<String> roles, Set<String> groups, SchemaRoutineName procedureName) {
        return this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true) != false && this.roleRegex.map(regex -> roles.stream().anyMatch(role -> regex.matcher((CharSequence)role).matches())).orElse(true) != false && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true) != false && this.schemaRegex.map(regex -> regex.matcher(procedureName.getSchemaName()).matches()).orElse(true) != false && this.procedureRegex.map(regex -> regex.matcher(procedureName.getRoutineName()).matches()).orElse(true) != false;
    }

    public boolean canExecuteProcedure() {
        return this.privileges.contains((Object)ProcedurePrivilege.EXECUTE) || this.canGrantExecuteProcedure();
    }

    public boolean canGrantExecuteProcedure() {
        return this.privileges.contains((Object)ProcedurePrivilege.GRANT_EXECUTE);
    }

    Optional<AnySchemaPermissionsRule> toAnySchemaPermissionsRule() {
        if (this.privileges.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnySchemaPermissionsRule(this.userRegex, this.roleRegex, this.groupRegex, this.schemaRegex));
    }

    Set<ProcedurePrivilege> getPrivileges() {
        return this.privileges;
    }

    Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    Optional<Pattern> getRoleRegex() {
        return this.roleRegex;
    }

    Optional<Pattern> getGroupRegex() {
        return this.groupRegex;
    }

    Optional<Pattern> getSchemaRegex() {
        return this.schemaRegex;
    }

    public static enum ProcedurePrivilege {
        EXECUTE,
        GRANT_EXECUTE;

    }
}

