/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.mapping.RemoteIdentifiers;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class ForwardingIdentifierMapping
implements IdentifierMapping {
    public static IdentifierMapping of(final Supplier<IdentifierMapping> delegateSupplier) {
        Objects.requireNonNull(delegateSupplier, "delegateSupplier is null");
        return new ForwardingIdentifierMapping(){

            @Override
            protected IdentifierMapping delegate() {
                return (IdentifierMapping)delegateSupplier.get();
            }
        };
    }

    protected abstract IdentifierMapping delegate();

    @Override
    public String fromRemoteSchemaName(String remoteSchemaName) {
        return this.delegate().fromRemoteSchemaName(remoteSchemaName);
    }

    @Override
    public String fromRemoteTableName(String remoteSchemaName, String remoteTableName) {
        return this.delegate().fromRemoteTableName(remoteSchemaName, remoteTableName);
    }

    @Override
    public String fromRemoteColumnName(String remoteColumnName) {
        return this.delegate().fromRemoteColumnName(remoteColumnName);
    }

    @Override
    public String toRemoteSchemaName(RemoteIdentifiers remoteIdentifiers, ConnectorIdentity identity, String schemaName) {
        return this.delegate().toRemoteSchemaName(remoteIdentifiers, identity, schemaName);
    }

    @Override
    public String toRemoteTableName(RemoteIdentifiers remoteIdentifiers, ConnectorIdentity identity, String remoteSchema, String tableName) {
        return this.delegate().toRemoteTableName(remoteIdentifiers, identity, remoteSchema, tableName);
    }

    @Override
    public String toRemoteColumnName(RemoteIdentifiers remoteIdentifiers, String columnName) {
        return this.delegate().toRemoteColumnName(remoteIdentifiers, columnName);
    }
}

