/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.calcite.util.CaseInsensitiveComparator;

public class NameMap<V> {
    private final NavigableMap<String, V> map;

    private NameMap(NavigableMap<String, V> map) {
        this.map = map;
        assert (this.map.comparator() == CaseInsensitiveComparator.COMPARATOR);
    }

    public NameMap() {
        this(new TreeMap(CaseInsensitiveComparator.COMPARATOR));
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NameMap && this.map.equals(((NameMap)obj).map);
    }

    public static <V> NameMap immutableCopyOf(Map<String, V> names) {
        return new NameMap<V>(ImmutableSortedMap.copyOf(names, CaseInsensitiveComparator.COMPARATOR));
    }

    public void put(String name, V v) {
        this.map.put(name, v);
    }

    public NavigableMap<String, V> range(String name, boolean caseSensitive) {
        Object ceilingKey;
        Object floorKey;
        if (caseSensitive) {
            floorKey = name;
            ceilingKey = name;
        } else {
            floorKey = CaseInsensitiveComparator.COMPARATOR.floorKey(name);
            ceilingKey = CaseInsensitiveComparator.COMPARATOR.ceilingKey(name);
        }
        NavigableMap<String, V> subMap = this.map.subMap((String)floorKey, true, (String)ceilingKey, true);
        return Collections.unmodifiableNavigableMap(subMap);
    }

    public boolean containsKey(String name, boolean caseSensitive) {
        return !this.range(name, caseSensitive).isEmpty();
    }

    public NavigableMap<String, V> map() {
        return this.map;
    }

    public V remove(String key) {
        return this.map.remove(key);
    }
}

