/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.List;

public class CompositeList<T>
extends AbstractList<T> {
    private final ImmutableList<List<T>> lists;

    private CompositeList(ImmutableList<List<T>> lists) {
        this.lists = lists;
    }

    @SafeVarargs
    public static <T> CompositeList<T> of(List<? extends T> ... lists) {
        return new CompositeList<T>(ImmutableList.copyOf(lists));
    }

    public static <T> CompositeList<T> ofCopy(Iterable<List<T>> lists) {
        ImmutableList<List<T>> list = ImmutableList.copyOf(lists);
        return new CompositeList<T>(list);
    }

    public static <T> List<T> of() {
        return ImmutableList.of();
    }

    public static <T> List<T> of(List<T> list0) {
        return list0;
    }

    public static <T> CompositeList<T> of(List<? extends T> list0, List<? extends T> list1) {
        return new CompositeList<T>(ImmutableList.of(list0, list1));
    }

    public static <T> CompositeList<T> of(List<? extends T> list0, List<? extends T> list1, List<? extends T> list2) {
        return new CompositeList<T>(ImmutableList.of(list0, list1, list2));
    }

    @Override
    public T get(int index) {
        for (List list : this.lists) {
            int nextIndex = index - list.size();
            if (nextIndex < 0) {
                return (T)list.get(index);
            }
            index = nextIndex;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        int n = 0;
        for (List list : this.lists) {
            n += list.size();
        }
        return n;
    }
}

