/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.util.Util;

class SchemaNamespace
extends AbstractNamespace {
    private final ImmutableList<String> names;

    SchemaNamespace(SqlValidatorImpl validator, ImmutableList<String> names) {
        super(validator, null);
        this.names = Objects.requireNonNull(names);
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        for (SqlMoniker moniker : this.validator.catalogReader.getAllSchemaObjectNames(this.names)) {
            List<String> names1 = moniker.getFullyQualifiedNames();
            SqlValidatorTable table = this.validator.catalogReader.getTable(names1);
            ((RelDataTypeFactory.Builder)builder).add(Util.last(names1), table.getRowType());
        }
        return builder.build();
    }

    @Override
    public SqlNode getNode() {
        return null;
    }
}

