/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;

public class SqlMapTypeNameSpec
extends SqlTypeNameSpec {
    private final SqlDataTypeSpec keyTypeSpec;
    private final SqlDataTypeSpec valTypeSpec;

    public SqlMapTypeNameSpec(SqlParserPos pos, SqlDataTypeSpec keyTypeSpec, SqlDataTypeSpec valTypeSpec) {
        super(new SqlIdentifier(SqlTypeName.MAP.getName(), pos), pos);
        this.keyTypeSpec = keyTypeSpec;
        this.valTypeSpec = valTypeSpec;
    }

    public SqlDataTypeSpec getKeyTypeSpec() {
        return this.keyTypeSpec;
    }

    public SqlDataTypeSpec getValTypeSpec() {
        return this.valTypeSpec;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator) {
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        return typeFactory.createMapType(this.keyTypeSpec.deriveType(validator), this.valTypeSpec.deriveType(validator));
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getTypeName().getSimple());
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "<", ">");
        writer.setNeedWhitespace(false);
        this.keyTypeSpec.unparse(writer, leftPrec, rightPrec);
        writer.sep(",", true);
        this.valTypeSpec.unparse(writer, leftPrec, rightPrec);
        writer.setNeedWhitespace(false);
        writer.endList(frame);
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec node, Litmus litmus) {
        if (!(node instanceof SqlMapTypeNameSpec)) {
            return this.fail(node, litmus);
        }
        SqlMapTypeNameSpec that = (SqlMapTypeNameSpec)node;
        if (!this.keyTypeSpec.equalsDeep((SqlNode)that.keyTypeSpec, litmus)) {
            return this.fail(node, litmus);
        }
        if (!this.valTypeSpec.equalsDeep((SqlNode)that.valTypeSpec, litmus)) {
            return this.fail(node, litmus);
        }
        return litmus.succeed();
    }

    private boolean fail(SqlTypeNameSpec node, Litmus litmus) {
        return litmus.fail("{} != {}", this, node);
    }
}

