/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.linkedin.coral.calcite.;
import com.linkedin.coral.calcite.$internal.com.google.common.base.Splitter;
import com.linkedin.coral.calcite.$internal.com.google.common.base.Strings;
import com.linkedin.coral.calcite.$internal.org.apache.commons.codec.digest.DigestUtils;
import com.linkedin.coral.calcite.$internal.org.apache.commons.codec.language.Soundex;
import com.linkedin.coral.calcite.$internal.org.apache.commons.lang3.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.CartesianProductEnumerator;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Like;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.NumberUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimeWithTimeZoneString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.Unsafe;
import org.apache.calcite.util.Util;

@Deterministic
public class SqlFunctions {
    private static final DecimalFormat DOUBLE_FORMAT = NumberUtil.decimalFormat("0.0E0");
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final DateTimeFormatter ROOT_DAY_FORMAT = DateTimeFormatter.ofPattern("EEEE", Locale.ROOT);
    private static final DateTimeFormatter ROOT_MONTH_FORMAT = DateTimeFormatter.ofPattern("MMMM", Locale.ROOT);
    private static final Soundex SOUNDEX = new Soundex();
    private static final int SOUNDEX_LENGTH = 4;
    private static final Pattern FROM_BASE64_REGEXP = Pattern.compile("[\\t\\n\\r\\s]");
    private static final Function1<List<Object>, Enumerable<Object>> LIST_AS_ENUMERABLE = Linq4j::asEnumerable;
    private static final String[] POSIX_CHARACTER_CLASSES = new String[]{"Lower", "Upper", "ASCII", "Alpha", "XDigit", "Digit", "Alnum", "Punct", "Graph", "Print", "Blank", "Cntrl", "Space"};
    private static final Function1<Object[], Enumerable<Object[]>> ARRAY_CARTESIAN_PRODUCT = lists -> {
        ArrayList enumerators = new ArrayList();
        for (Object list : lists) {
            enumerators.add(Linq4j.enumerator((List)list));
        }
        final Enumerator product = Linq4j.product(enumerators);
        return new AbstractEnumerable<Object[]>(){

            @Override
            public Enumerator<Object[]> enumerator() {
                return Linq4j.transform(product, List::toArray);
            }
        };
    };
    private static final ThreadLocal<Map<String, AtomicLong>> THREAD_SEQUENCES = ThreadLocal.withInitial(HashMap::new);

    private SqlFunctions() {
    }

    public static String toBase64(String string) {
        return SqlFunctions.toBase64_(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String toBase64(ByteString string) {
        return SqlFunctions.toBase64_(string.getBytes());
    }

    private static String toBase64_(byte[] bytes) {
        String base64 = Base64.getEncoder().encodeToString(bytes);
        StringBuilder str = new StringBuilder(base64.length() + base64.length() / 76);
        Splitter.fixedLength(76).split(base64).iterator().forEachRemaining(s2 -> {
            str.append((String)s2);
            str.append("\n");
        });
        return str.substring(0, str.length() - 1);
    }

    public static ByteString fromBase64(String base64) {
        try {
            base64 = FROM_BASE64_REGEXP.matcher(base64).replaceAll("");
            return new ByteString(Base64.getDecoder().decode(base64));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @.Nonnull
    public static String md5(@.Nonnull String string) {
        return DigestUtils.md5Hex(string.getBytes(StandardCharsets.UTF_8));
    }

    @.Nonnull
    public static String md5(@.Nonnull ByteString string) {
        return DigestUtils.md5Hex(string.getBytes());
    }

    @.Nonnull
    public static String sha1(@.Nonnull String string) {
        return DigestUtils.sha1Hex(string.getBytes(StandardCharsets.UTF_8));
    }

    @.Nonnull
    public static String sha1(@.Nonnull ByteString string) {
        return DigestUtils.sha1Hex(string.getBytes());
    }

    public static String regexpReplace(String s2, String regex, String replacement) {
        return SqlFunctions.regexpReplace(s2, regex, replacement, 1, 0, null);
    }

    public static String regexpReplace(String s2, String regex, String replacement, int pos) {
        return SqlFunctions.regexpReplace(s2, regex, replacement, pos, 0, null);
    }

    public static String regexpReplace(String s2, String regex, String replacement, int pos, int occurrence) {
        return SqlFunctions.regexpReplace(s2, regex, replacement, pos, occurrence, null);
    }

    public static String regexpReplace(String s2, String regex, String replacement, int pos, int occurrence, String matchType) {
        if (pos < 1 || pos > s2.length()) {
            throw Static.RESOURCE.invalidInputForRegexpReplace(Integer.toString(pos)).ex();
        }
        int flags = SqlFunctions.makeRegexpFlags(matchType);
        Pattern pattern = Pattern.compile(regex, flags);
        return Unsafe.regexpReplace(s2, pattern, replacement, pos, occurrence);
    }

    private static int makeRegexpFlags(String stringFlags) {
        int flags = 0;
        if (stringFlags != null) {
            block6: for (int i = 0; i < stringFlags.length(); ++i) {
                switch (stringFlags.charAt(i)) {
                    case 'i': {
                        flags |= 2;
                        continue block6;
                    }
                    case 'c': {
                        flags &= 0xFFFFFFFD;
                        continue block6;
                    }
                    case 'n': {
                        flags |= 0x20;
                        continue block6;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block6;
                    }
                    default: {
                        throw Static.RESOURCE.invalidInputForRegexpReplace(stringFlags).ex();
                    }
                }
            }
        }
        return flags;
    }

    public static String substring(String c, int s2, int l) {
        int e;
        int lc = c.length();
        if (s2 < 0) {
            s2 += lc + 1;
        }
        if ((e = s2 + l) < s2) {
            throw Static.RESOURCE.illegalNegativeSubstringLength().ex();
        }
        if (s2 > lc || e < 1) {
            return "";
        }
        int s1 = Math.max(s2, 1);
        int e1 = Math.min(e, lc + 1);
        return c.substring(s1 - 1, e1 - 1);
    }

    public static String substring(String c, int s2) {
        return SqlFunctions.substring(c, s2, c.length() + 1);
    }

    public static ByteString substring(ByteString c, int s2, int l) {
        int e;
        int lc = c.length();
        if (s2 < 0) {
            s2 += lc + 1;
        }
        if ((e = s2 + l) < s2) {
            throw Static.RESOURCE.illegalNegativeSubstringLength().ex();
        }
        if (s2 > lc || e < 1) {
            return ByteString.EMPTY;
        }
        int s1 = Math.max(s2, 1);
        int e1 = Math.min(e, lc + 1);
        return c.substring(s1 - 1, e1 - 1);
    }

    public static ByteString substring(ByteString c, int s2) {
        return SqlFunctions.substring(c, s2, c.length() + 1);
    }

    public static String upper(String s2) {
        return s2.toUpperCase(Locale.ROOT);
    }

    public static String lower(String s2) {
        return s2.toLowerCase(Locale.ROOT);
    }

    public static String initcap(String s2) {
        int len = s2.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s2.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static String reverse(String s2) {
        StringBuilder buf = new StringBuilder(s2);
        return buf.reverse().toString();
    }

    public static int ascii(String s2) {
        return s2.isEmpty() ? 0 : s2.codePointAt(0);
    }

    public static String repeat(String s2, int n) {
        if (n < 1) {
            return "";
        }
        return Strings.repeat(s2, n);
    }

    public static String space(int n) {
        return SqlFunctions.repeat(" ", n);
    }

    public static String soundex(String s2) {
        return SOUNDEX.soundex(s2);
    }

    public static int difference(String s0, String s1) {
        String result0 = SqlFunctions.soundex(s0);
        String result1 = SqlFunctions.soundex(s1);
        for (int i = 0; i < 4; ++i) {
            if (result0.charAt(i) == result1.charAt(i)) continue;
            return i;
        }
        return 4;
    }

    @.Nonnull
    public static String left(@.Nonnull String s2, int n) {
        if (n <= 0) {
            return "";
        }
        int len = s2.length();
        if (n >= len) {
            return s2;
        }
        return s2.substring(0, n);
    }

    @.Nonnull
    public static ByteString left(@.Nonnull ByteString s2, int n) {
        if (n <= 0) {
            return ByteString.EMPTY;
        }
        int len = s2.length();
        if (n >= len) {
            return s2;
        }
        return s2.substring(0, n);
    }

    @.Nonnull
    public static String right(@.Nonnull String s2, int n) {
        if (n <= 0) {
            return "";
        }
        int len = s2.length();
        if (n >= len) {
            return s2;
        }
        return s2.substring(len - n);
    }

    @.Nonnull
    public static ByteString right(@.Nonnull ByteString s2, int n) {
        if (n <= 0) {
            return ByteString.EMPTY;
        }
        int len = s2.length();
        if (n >= len) {
            return s2;
        }
        return s2.substring(len - n);
    }

    public static String chr(long n) {
        return String.valueOf(Character.toChars((int)n));
    }

    public static int charLength(String s2) {
        return s2.length();
    }

    public static String concat(String s0, String s1) {
        return s0 + s1;
    }

    public static ByteString concat(ByteString s0, ByteString s1) {
        return s0.concat(s1);
    }

    public static String rtrim(String s2) {
        return SqlFunctions.trim(false, true, " ", s2);
    }

    public static String ltrim(String s2) {
        return SqlFunctions.trim(true, false, " ", s2);
    }

    public static String trim(boolean left, boolean right, String seek, String s2) {
        return SqlFunctions.trim(left, right, seek, s2, true);
    }

    public static String trim(boolean left, boolean right, String seek, String s2, boolean strict) {
        if (strict && seek.length() != 1) {
            throw Static.RESOURCE.trimError().ex();
        }
        int j = s2.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return "";
                }
                if (seek.indexOf(s2.charAt(j - 1)) < 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return "";
                }
                if (seek.indexOf(s2.charAt(i)) < 0) break;
                ++i;
            }
        }
        return s2.substring(i, j);
    }

    public static ByteString trim(ByteString s2) {
        return SqlFunctions.trim_(s2, true, true);
    }

    public static ByteString rtrim(ByteString s2) {
        return SqlFunctions.trim_(s2, false, true);
    }

    private static ByteString trim_(ByteString s2, boolean left, boolean right) {
        int j = s2.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return ByteString.EMPTY;
                }
                if (s2.byteAt(j - 1) != 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return ByteString.EMPTY;
                }
                if (s2.byteAt(i) != 0) break;
                ++i;
            }
        }
        return s2.substring(i, j);
    }

    public static String overlay(String s2, String r, int start) {
        return s2.substring(0, start - 1) + r + s2.substring(start - 1 + r.length());
    }

    public static String overlay(String s2, String r, int start, int length) {
        return s2.substring(0, start - 1) + r + s2.substring(start - 1 + length);
    }

    public static ByteString overlay(ByteString s2, ByteString r, int start) {
        return s2.substring(0, start - 1).concat(r).concat(s2.substring(start - 1 + r.length()));
    }

    public static ByteString overlay(ByteString s2, ByteString r, int start, int length) {
        return s2.substring(0, start - 1).concat(r).concat(s2.substring(start - 1 + length));
    }

    public static boolean like(String s2, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.matches(regex, s2);
    }

    public static boolean like(String s2, String pattern, String escape) {
        String regex = Like.sqlToRegexLike(pattern, escape);
        return Pattern.matches(regex, s2);
    }

    public static boolean similar(String s2, String pattern) {
        String regex = Like.sqlToRegexSimilar(pattern, null);
        return Pattern.matches(regex, s2);
    }

    public static boolean similar(String s2, String pattern, String escape) {
        String regex = Like.sqlToRegexSimilar(pattern, escape);
        return Pattern.matches(regex, s2);
    }

    public static boolean posixRegex(String s2, String regex, Boolean caseSensitive) {
        String[] existingExpressions;
        String originalRegex = regex;
        for (String v2 : existingExpressions = (String[])Arrays.stream(POSIX_CHARACTER_CLASSES).filter(v -> originalRegex.contains(v.toLowerCase(Locale.ROOT))).toArray(String[]::new)) {
            regex = regex.replaceAll(v2.toLowerCase(Locale.ROOT), "\\\\p{" + v2 + "}");
        }
        int flags = caseSensitive != false ? 0 : 2;
        return Pattern.compile(regex, flags).matcher(s2).find();
    }

    public static boolean eq(BigDecimal b0, BigDecimal b1) {
        return b0.stripTrailingZeros().equals(b1.stripTrailingZeros());
    }

    public static boolean eq(Object b0, Object b1) {
        return b0.equals(b1);
    }

    public static boolean eqAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass())) {
            if (BigDecimal.class.isInstance(b0)) {
                return SqlFunctions.eq((BigDecimal)b0, (BigDecimal)b1);
            }
            return b0.equals(b1);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.eq(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        return false;
    }

    private static boolean allAssignable(Class clazz, Object o0, Object o1) {
        return clazz.isInstance(o0) && clazz.isInstance(o1);
    }

    public static boolean ne(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) != 0;
    }

    public static boolean ne(Object b0, Object b1) {
        return !SqlFunctions.eq(b0, b1);
    }

    public static boolean neAny(Object b0, Object b1) {
        return !SqlFunctions.eqAny(b0, b1);
    }

    public static boolean lt(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) < 0;
    }

    public static boolean lt(String b0, String b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean ltAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) < 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.lt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<", b0, b1);
    }

    public static boolean le(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) <= 0;
    }

    public static boolean le(String b0, String b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean leAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) <= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.le(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<=", b0, b1);
    }

    public static boolean gt(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) > 0;
    }

    public static boolean gt(String b0, String b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gtAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) > 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.gt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">", b0, b1);
    }

    public static boolean ge(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) >= 0;
    }

    public static boolean ge(String b0, String b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean geAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) >= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.ge(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">=", b0, b1);
    }

    public static int plus(int b0, int b1) {
        return b0 + b1;
    }

    public static Integer plus(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Integer plus(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Integer plus(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Long plus(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 + b1.longValue());
    }

    public static Long plus(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() + b1);
    }

    public static BigDecimal plus(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.add(b1);
    }

    public static Object plusAny(Object b0, Object b1) {
        if (b0 == null || b1 == null) {
            return null;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.plus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("+", b0, b1);
    }

    public static int minus(int b0, int b1) {
        return b0 - b1;
    }

    public static Integer minus(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Integer minus(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Integer minus(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Long minus(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 - b1.longValue());
    }

    public static Long minus(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() - b1);
    }

    public static BigDecimal minus(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.subtract(b1);
    }

    public static Object minusAny(Object b0, Object b1) {
        if (b0 == null || b1 == null) {
            return null;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.minus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("-", b0, b1);
    }

    public static int divide(int b0, int b1) {
        return b0 / b1;
    }

    public static Integer divide(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Integer divide(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Integer divide(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Long divide(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 / b1.longValue());
    }

    public static Long divide(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() / b1);
    }

    public static BigDecimal divide(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.divide(b1, MathContext.DECIMAL64);
    }

    public static Object divideAny(Object b0, Object b1) {
        if (b0 == null || b1 == null) {
            return null;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.divide(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("/", b0, b1);
    }

    public static int divide(int b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).intValue();
    }

    public static long divide(long b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).longValue();
    }

    public static int multiply(int b0, int b1) {
        return b0 * b1;
    }

    public static Integer multiply(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Integer multiply(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Integer multiply(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Long multiply(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 * b1.longValue());
    }

    public static Long multiply(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() * b1);
    }

    public static BigDecimal multiply(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.multiply(b1);
    }

    public static Object multiplyAny(Object b0, Object b1) {
        if (b0 == null || b1 == null) {
            return null;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.multiply(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("*", b0, b1);
    }

    private static RuntimeException notArithmetic(String op, Object b0, Object b1) {
        return Static.RESOURCE.invalidTypesForArithmetic(b0.getClass().toString(), op, b1.getClass().toString()).ex();
    }

    private static RuntimeException notComparable(String op, Object b0, Object b1) {
        return Static.RESOURCE.invalidTypesForComparison(b0.getClass().toString(), op, b1.getClass().toString()).ex();
    }

    public static long bitAnd(long b0, long b1) {
        return b0 & b1;
    }

    public static long bitOr(long b0, long b1) {
        return b0 | b1;
    }

    public static double exp(double b0) {
        return Math.exp(b0);
    }

    public static double exp(BigDecimal b0) {
        return Math.exp(b0.doubleValue());
    }

    public static double power(double b0, double b1) {
        return Math.pow(b0, b1);
    }

    public static double power(double b0, BigDecimal b1) {
        return Math.pow(b0, b1.doubleValue());
    }

    public static double power(BigDecimal b0, double b1) {
        return Math.pow(b0.doubleValue(), b1);
    }

    public static double power(BigDecimal b0, BigDecimal b1) {
        return Math.pow(b0.doubleValue(), b1.doubleValue());
    }

    public static double ln(double d) {
        return Math.log(d);
    }

    public static double ln(BigDecimal d) {
        return Math.log(d.doubleValue());
    }

    public static double log10(double b0) {
        return Math.log10(b0);
    }

    public static double log10(BigDecimal d) {
        return Math.log10(d.doubleValue());
    }

    public static byte mod(byte b0, byte b1) {
        return (byte)(b0 % b1);
    }

    public static short mod(short b0, short b1) {
        return (short)(b0 % b1);
    }

    public static int mod(int b0, int b1) {
        return b0 % b1;
    }

    public static long mod(long b0, long b1) {
        return b0 % b1;
    }

    public static BigDecimal mod(BigDecimal b0, int b1) {
        return SqlFunctions.mod(b0, BigDecimal.valueOf(b1));
    }

    public static int mod(int b0, BigDecimal b1) {
        return SqlFunctions.mod(b0, b1.intValue());
    }

    public static BigDecimal mod(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        return bigDecimals[1];
    }

    public static double floor(double b0) {
        return Math.floor(b0);
    }

    public static float floor(float b0) {
        return (float)Math.floor(b0);
    }

    public static BigDecimal floor(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.FLOOR);
    }

    public static byte floor(byte b0, byte b1) {
        return (byte)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static short floor(short b0, short b1) {
        return (short)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static int floor(int b0, int b1) {
        int r = b0 % b1;
        if (r < 0) {
            r += b1;
        }
        return b0 - r;
    }

    public static long floor(long b0, long b1) {
        long r = b0 % b1;
        if (r < 0L) {
            r += b1;
        }
        return b0 - r;
    }

    public static BigDecimal floor(BigDecimal b0, int b1) {
        return SqlFunctions.floor(b0, BigDecimal.valueOf(b1));
    }

    public static int floor(int b0, BigDecimal b1) {
        return SqlFunctions.floor(b0, b1.intValue());
    }

    public static BigDecimal floor(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() < 0) {
            r = r.add(b1);
        }
        return b0.subtract(r);
    }

    public static double ceil(double b0) {
        return Math.ceil(b0);
    }

    public static float ceil(float b0) {
        return (float)Math.ceil(b0);
    }

    public static BigDecimal ceil(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.CEILING);
    }

    public static byte ceil(byte b0, byte b1) {
        return SqlFunctions.floor((byte)(b0 + b1 - 1), b1);
    }

    public static short ceil(short b0, short b1) {
        return SqlFunctions.floor((short)(b0 + b1 - 1), b1);
    }

    public static int ceil(int b0, int b1) {
        int r = b0 % b1;
        if (r > 0) {
            r -= b1;
        }
        return b0 - r;
    }

    public static long ceil(long b0, long b1) {
        return SqlFunctions.floor(b0 + b1 - 1L, b1);
    }

    public static BigDecimal ceil(BigDecimal b0, int b1) {
        return SqlFunctions.ceil(b0, BigDecimal.valueOf(b1));
    }

    public static int ceil(int b0, BigDecimal b1) {
        return SqlFunctions.ceil(b0, b1.intValue());
    }

    public static BigDecimal ceil(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() > 0) {
            r = r.subtract(b1);
        }
        return b0.subtract(r);
    }

    public static byte abs(byte b0) {
        return (byte)Math.abs(b0);
    }

    public static short abs(short b0) {
        return (short)Math.abs(b0);
    }

    public static int abs(int b0) {
        return Math.abs(b0);
    }

    public static long abs(long b0) {
        return Math.abs(b0);
    }

    public static float abs(float b0) {
        return Math.abs(b0);
    }

    public static double abs(double b0) {
        return Math.abs(b0);
    }

    public static BigDecimal abs(BigDecimal b0) {
        return b0.abs();
    }

    public static double acos(BigDecimal b0) {
        return Math.acos(b0.doubleValue());
    }

    public static double acos(double b0) {
        return Math.acos(b0);
    }

    public static double asin(BigDecimal b0) {
        return Math.asin(b0.doubleValue());
    }

    public static double asin(double b0) {
        return Math.asin(b0);
    }

    public static double atan(BigDecimal b0) {
        return Math.atan(b0.doubleValue());
    }

    public static double atan(double b0) {
        return Math.atan(b0);
    }

    public static double atan2(double b0, BigDecimal b1) {
        return Math.atan2(b0, b1.doubleValue());
    }

    public static double atan2(BigDecimal b0, double b1) {
        return Math.atan2(b0.doubleValue(), b1);
    }

    public static double atan2(BigDecimal b0, BigDecimal b1) {
        return Math.atan2(b0.doubleValue(), b1.doubleValue());
    }

    public static double atan2(double b0, double b1) {
        return Math.atan2(b0, b1);
    }

    public static double cos(BigDecimal b0) {
        return Math.cos(b0.doubleValue());
    }

    public static double cos(double b0) {
        return Math.cos(b0);
    }

    public static double cot(BigDecimal b0) {
        return 1.0 / Math.tan(b0.doubleValue());
    }

    public static double cot(double b0) {
        return 1.0 / Math.tan(b0);
    }

    public static double degrees(BigDecimal b0) {
        return Math.toDegrees(b0.doubleValue());
    }

    public static double degrees(double b0) {
        return Math.toDegrees(b0);
    }

    public static double radians(BigDecimal b0) {
        return Math.toRadians(b0.doubleValue());
    }

    public static double radians(double b0) {
        return Math.toRadians(b0);
    }

    public static int sround(int b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static int sround(int b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long sround(long b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static long sround(long b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal sround(BigDecimal b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static BigDecimal sround(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.HALF_UP).movePointLeft(b1);
    }

    public static double sround(double b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static double sround(double b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int struncate(int b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static int struncate(int b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long struncate(long b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static long struncate(long b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal struncate(BigDecimal b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static BigDecimal struncate(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.DOWN).movePointLeft(b1);
    }

    public static double struncate(double b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static double struncate(double b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int sign(int b0) {
        return Integer.signum(b0);
    }

    public static long sign(long b0) {
        return Long.signum(b0);
    }

    public static BigDecimal sign(BigDecimal b0) {
        return BigDecimal.valueOf(b0.signum());
    }

    public static double sign(double b0) {
        return Math.signum(b0);
    }

    public static double sin(BigDecimal b0) {
        return Math.sin(b0.doubleValue());
    }

    public static double sin(double b0) {
        return Math.sin(b0);
    }

    public static double tan(BigDecimal b0) {
        return Math.tan(b0.doubleValue());
    }

    public static double tan(double b0) {
        return Math.tan(b0);
    }

    public static <T extends Comparable<T>> T lesser(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T least(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static boolean greater(boolean b0, boolean b1) {
        return b0 || b1;
    }

    public static boolean lesser(boolean b0, boolean b1) {
        return b0 && b1;
    }

    public static byte greater(byte b0, byte b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static byte lesser(byte b0, byte b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static char greater(char b0, char b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static char lesser(char b0, char b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static short greater(short b0, short b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static short lesser(short b0, short b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static int greater(int b0, int b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static int lesser(int b0, int b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static long greater(long b0, long b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static long lesser(long b0, long b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static float greater(float b0, float b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static float lesser(float b0, float b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static double greater(double b0, double b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static double lesser(double b0, double b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greater(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greatest(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static int compare(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    public static String toString(float x) {
        if (x == 0.0f) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL32).stripTrailingZeros();
        String s2 = bigDecimal.toString();
        return s2.replaceAll("0*E", "E").replace("E+", "E");
    }

    public static String toString(double x) {
        if (x == 0.0) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL64).stripTrailingZeros();
        String s2 = bigDecimal.toString();
        return s2.replaceAll("0*E", "E").replace("E+", "E");
    }

    public static String toString(BigDecimal x) {
        String s2 = x.toString();
        if (s2.startsWith("0")) {
            return s2.substring(1);
        }
        if (s2.startsWith("-0")) {
            return "-" + s2.substring(2);
        }
        return s2;
    }

    public static String toString(boolean x) {
        return x ? "TRUE" : "FALSE";
    }

    @NonDeterministic
    private static Object cannotConvert(Object o, Class toType) {
        throw Static.RESOURCE.cannotConvert(o.toString(), toType.toString()).ex();
    }

    public static boolean toBoolean(String s2) {
        if ((s2 = SqlFunctions.trim(true, true, " ", s2)).equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s2.equalsIgnoreCase("FALSE")) {
            return false;
        }
        throw Static.RESOURCE.invalidCharacterForCast(s2).ex();
    }

    public static boolean toBoolean(Number number) {
        return !number.equals(0);
    }

    public static boolean toBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : (o instanceof Number ? SqlFunctions.toBoolean((Number)o) : (o instanceof String ? SqlFunctions.toBoolean((String)o) : (Boolean)SqlFunctions.cannotConvert(o, Boolean.TYPE)));
    }

    public static byte toByte(Object o) {
        return o instanceof Byte ? (Byte)o : (o instanceof Number ? SqlFunctions.toByte((Number)o) : Byte.parseByte(o.toString()));
    }

    public static byte toByte(Number number) {
        return number.byteValue();
    }

    public static char toChar(String s2) {
        return s2.charAt(0);
    }

    public static Character toCharBoxed(String s2) {
        return Character.valueOf(s2.charAt(0));
    }

    public static short toShort(String s2) {
        return Short.parseShort(s2.trim());
    }

    public static short toShort(Number number) {
        return number.shortValue();
    }

    public static short toShort(Object o) {
        return o instanceof Short ? (Short)o : (o instanceof Number ? SqlFunctions.toShort((Number)o) : (o instanceof String ? SqlFunctions.toShort((String)o) : (Short)SqlFunctions.cannotConvert(o, Short.TYPE)));
    }

    public static int toInt(java.util.Date v) {
        return SqlFunctions.toInt(v, LOCAL_TZ);
    }

    public static int toInt(java.util.Date v, TimeZone timeZone) {
        return (int)(SqlFunctions.toLong(v, timeZone) / 86400000L);
    }

    public static Integer toIntOptional(java.util.Date v) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static Integer toIntOptional(java.util.Date v, TimeZone timeZone) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v, timeZone));
    }

    public static long toLong(java.util.Date v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static int toInt(Time v) {
        return (int)(SqlFunctions.toLong(v) % 86400000L);
    }

    public static Integer toIntOptional(Time v) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static int toInt(String s2) {
        return Integer.parseInt(s2.trim());
    }

    public static int toInt(Number number) {
        return number.intValue();
    }

    public static int toInt(Object o) {
        return o instanceof Integer ? (Integer)o : (o instanceof Number ? SqlFunctions.toInt((Number)o) : (o instanceof String ? SqlFunctions.toInt((String)o) : (o instanceof java.util.Date ? SqlFunctions.toInt((java.util.Date)o) : (Integer)SqlFunctions.cannotConvert(o, Integer.TYPE))));
    }

    public static long toLong(Timestamp v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(java.util.Date v, TimeZone timeZone) {
        long time = v.getTime();
        return time + (long)timeZone.getOffset(time);
    }

    public static Long toLongOptional(java.util.Date v) {
        return v == null ? null : Long.valueOf(SqlFunctions.toLong(v, LOCAL_TZ));
    }

    public static Long toLongOptional(Timestamp v, TimeZone timeZone) {
        if (v == null) {
            return null;
        }
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(String s2) {
        if (s2.startsWith("199") && s2.contains(":")) {
            return Timestamp.valueOf(s2).getTime();
        }
        return Long.parseLong(s2.trim());
    }

    public static long toLong(Number number) {
        return number.longValue();
    }

    public static long toLong(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof Number ? SqlFunctions.toLong((Number)o) : (o instanceof String ? SqlFunctions.toLong((String)o) : (Long)SqlFunctions.cannotConvert(o, Long.TYPE)));
    }

    public static float toFloat(String s2) {
        return Float.parseFloat(s2.trim());
    }

    public static float toFloat(Number number) {
        return number.floatValue();
    }

    public static float toFloat(Object o) {
        return o instanceof Float ? ((Float)o).floatValue() : (o instanceof Number ? SqlFunctions.toFloat((Number)o) : (o instanceof String ? SqlFunctions.toFloat((String)o) : ((Float)SqlFunctions.cannotConvert(o, Float.TYPE)).floatValue()));
    }

    public static double toDouble(String s2) {
        return Double.parseDouble(s2.trim());
    }

    public static double toDouble(Number number) {
        return number.doubleValue();
    }

    public static double toDouble(Object o) {
        return o instanceof Double ? (Double)o : (o instanceof Number ? SqlFunctions.toDouble((Number)o) : (o instanceof String ? SqlFunctions.toDouble((String)o) : (Double)SqlFunctions.cannotConvert(o, Double.TYPE)));
    }

    public static BigDecimal toBigDecimal(String s2) {
        return new BigDecimal(s2.trim());
    }

    public static BigDecimal toBigDecimal(Number number) {
        return number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Long ? new BigDecimal(number.longValue()) : new BigDecimal(number.doubleValue())));
    }

    public static BigDecimal toBigDecimal(Object o) {
        return o instanceof Number ? SqlFunctions.toBigDecimal((Number)o) : SqlFunctions.toBigDecimal(o.toString());
    }

    public static Date internalToDate(int v) {
        long t = (long)v * 86400000L;
        return new Date(t - (long)LOCAL_TZ.getOffset(t));
    }

    public static Date internalToDate(Integer v) {
        return v == null ? null : SqlFunctions.internalToDate((int)v);
    }

    public static Time internalToTime(int v) {
        return new Time(v - LOCAL_TZ.getOffset(v));
    }

    public static Time internalToTime(Integer v) {
        return v == null ? null : SqlFunctions.internalToTime((int)v);
    }

    public static Integer toTimeWithLocalTimeZone(String v) {
        return v == null ? null : Integer.valueOf(new TimeWithTimeZoneString(v).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimeString().getMillisOfDay());
    }

    public static Integer toTimeWithLocalTimeZone(String v, TimeZone timeZone) {
        return v == null ? null : Integer.valueOf(new TimeWithTimeZoneString(v + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimeString().getMillisOfDay());
    }

    public static int timeWithLocalTimeZoneToTime(int v, TimeZone timeZone) {
        return TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(timeZone).getLocalTimeString().getMillisOfDay();
    }

    public static long timeWithLocalTimeZoneToTimestamp(String date, int v, TimeZone timeZone) {
        TimeWithTimeZoneString tTZ = TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(DateTimeUtils.UTC_ZONE);
        return new TimestampWithTimeZoneString(date + " " + tTZ.toString()).withTimeZone(timeZone).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static long timeWithLocalTimeZoneToTimestampWithLocalTimeZone(String date, int v) {
        TimeWithTimeZoneString tTZ = TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(DateTimeUtils.UTC_ZONE);
        return new TimestampWithTimeZoneString(date + " " + tTZ.toString()).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static String timeWithLocalTimeZoneToString(int v, TimeZone timeZone) {
        return TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(timeZone).toString();
    }

    public static Timestamp internalToTimestamp(long v) {
        return new Timestamp(v - (long)LOCAL_TZ.getOffset(v));
    }

    public static Timestamp internalToTimestamp(Long v) {
        return v == null ? null : SqlFunctions.internalToTimestamp((long)v);
    }

    public static int timestampWithLocalTimeZoneToDate(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalDateString().getDaysSinceEpoch();
    }

    public static int timestampWithLocalTimeZoneToTime(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalTimeString().getMillisOfDay();
    }

    public static long timestampWithLocalTimeZoneToTimestamp(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static String timestampWithLocalTimeZoneToString(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).toString();
    }

    public static int timestampWithLocalTimeZoneToTimeWithLocalTimeZone(long v) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).getLocalTimeString().getMillisOfDay();
    }

    public static Long toTimestampWithLocalTimeZone(String v) {
        return v == null ? null : Long.valueOf(new TimestampWithTimeZoneString(v).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString().getMillisSinceEpoch());
    }

    public static Long toTimestampWithLocalTimeZone(String v, TimeZone timeZone) {
        return v == null ? null : Long.valueOf(new TimestampWithTimeZoneString(v + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString().getMillisSinceEpoch());
    }

    public static String truncate(String s2, int maxLength) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() > maxLength) {
            return s2.substring(0, maxLength);
        }
        return s2;
    }

    public static String truncateOrPad(String s2, int maxLength) {
        if (s2 == null) {
            return null;
        }
        int length = s2.length();
        if (length > maxLength) {
            return s2.substring(0, maxLength);
        }
        return length < maxLength ? Spaces.padRight(s2, maxLength) : s2;
    }

    public static ByteString truncate(ByteString s2, int maxLength) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() > maxLength) {
            return s2.substring(0, maxLength);
        }
        return s2;
    }

    public static ByteString truncateOrPad(ByteString s2, int maxLength) {
        if (s2 == null) {
            return null;
        }
        int length = s2.length();
        if (length > maxLength) {
            return s2.substring(0, maxLength);
        }
        if (length < maxLength) {
            return s2.concat(new ByteString(new byte[maxLength - length]));
        }
        return s2;
    }

    public static int position(String seek, String s2) {
        return s2.indexOf(seek) + 1;
    }

    public static int position(ByteString seek, ByteString s2) {
        return s2.indexOf(seek) + 1;
    }

    public static int position(String seek, String s2, int from) {
        int from0 = from - 1;
        if (from0 > s2.length() || from0 < 0) {
            return 0;
        }
        return s2.indexOf(seek, from0) + 1;
    }

    public static int position(ByteString seek, ByteString s2, int from) {
        int from0 = from - 1;
        if (from0 > s2.length() || from0 < 0) {
            return 0;
        }
        Bug.upgrade("in avatica-1.9, use ByteString.substring(ByteString, int)");
        int p = s2.substring(from0).indexOf(seek);
        if (p < 0) {
            return 0;
        }
        return p + from;
    }

    public static long round(long v, long x) {
        return SqlFunctions.truncate(v + x / 2L, x);
    }

    public static long truncate(long v, long x) {
        long remainder = v % x;
        if (remainder < 0L) {
            remainder += x;
        }
        return v - remainder;
    }

    public static int round(int v, int x) {
        return SqlFunctions.truncate(v + x / 2, x);
    }

    public static int truncate(int v, int x) {
        int remainder = v % x;
        if (remainder < 0) {
            remainder += x;
        }
        return v - remainder;
    }

    public static int lastDay(int date) {
        int y0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.YEAR, date);
        int m0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.MONTH, date);
        int last = SqlFunctions.lastDay(y0, m0);
        return DateTimeUtils.ymdToUnixDate(y0, m0, last);
    }

    public static int lastDay(long timestamp) {
        int date = (int)(timestamp / 86400000L);
        int y0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.YEAR, date);
        int m0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.MONTH, date);
        int last = SqlFunctions.lastDay(y0, m0);
        return DateTimeUtils.ymdToUnixDate(y0, m0, last);
    }

    public static String dayNameWithTimestamp(long timestamp, Locale locale) {
        return SqlFunctions.timeStampToLocalDate(timestamp).format(ROOT_DAY_FORMAT.withLocale(locale));
    }

    public static String dayNameWithDate(int date, Locale locale) {
        return SqlFunctions.dateToLocalDate(date).format(ROOT_DAY_FORMAT.withLocale(locale));
    }

    public static String monthNameWithTimestamp(long timestamp, Locale locale) {
        return SqlFunctions.timeStampToLocalDate(timestamp).format(ROOT_MONTH_FORMAT.withLocale(locale));
    }

    public static String monthNameWithDate(int date, Locale locale) {
        return SqlFunctions.dateToLocalDate(date).format(ROOT_MONTH_FORMAT.withLocale(locale));
    }

    private static LocalDate dateToLocalDate(int date) {
        int y0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.YEAR, date);
        int m0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.MONTH, date);
        int d0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.DAY, date);
        return LocalDate.of(y0, m0, d0);
    }

    private static LocalDate timeStampToLocalDate(long timestamp) {
        int date = (int)(timestamp / 86400000L);
        return SqlFunctions.dateToLocalDate(date);
    }

    @NonDeterministic
    public static long currentTimestamp(DataContext root) {
        return (Long)DataContext.Variable.CURRENT_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int currentTime(DataContext root) {
        int time = (int)(SqlFunctions.currentTimestamp(root) % 86400000L);
        if (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        return time;
    }

    @NonDeterministic
    public static int currentDate(DataContext root) {
        long timestamp = SqlFunctions.currentTimestamp(root);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
        }
        return date;
    }

    @NonDeterministic
    public static long localTimestamp(DataContext root) {
        return (Long)DataContext.Variable.LOCAL_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int localTime(DataContext root) {
        return (int)(SqlFunctions.localTimestamp(root) % 86400000L);
    }

    @NonDeterministic
    public static TimeZone timeZone(DataContext root) {
        return (TimeZone)DataContext.Variable.TIME_ZONE.get(root);
    }

    @Deterministic
    public static String user(DataContext root) {
        return (String)Objects.requireNonNull(DataContext.Variable.USER.get(root));
    }

    @Deterministic
    public static String systemUser(DataContext root) {
        return (String)Objects.requireNonNull(DataContext.Variable.SYSTEM_USER.get(root));
    }

    @NonDeterministic
    public static Locale locale(DataContext root) {
        return (Locale)DataContext.Variable.LOCALE.get(root);
    }

    public static String translate3(String s2, String search, String replacement) {
        return StringUtils.replaceChars(s2, search, replacement);
    }

    public static String replace(String s2, String search, String replacement) {
        return s2.replace(search, replacement);
    }

    public static Object arrayItem(List list, int item) {
        if (item < 1 || item > list.size()) {
            return null;
        }
        return list.get(item - 1);
    }

    public static Object mapItem(Map map, Object item) {
        return map.get(item);
    }

    public static Object item(Object object, Object index) {
        if (object instanceof Map) {
            return SqlFunctions.mapItem((Map)object, index);
        }
        if (object instanceof List && index instanceof Number) {
            return SqlFunctions.arrayItem((List)object, ((Number)index).intValue());
        }
        return null;
    }

    public static Object arrayItemOptional(List list, int item) {
        if (list == null) {
            return null;
        }
        return SqlFunctions.arrayItem(list, item);
    }

    public static Object mapItemOptional(Map map, Object item) {
        if (map == null) {
            return null;
        }
        return SqlFunctions.mapItem(map, item);
    }

    public static Object itemOptional(Object object, Object index) {
        if (object == null) {
            return null;
        }
        return SqlFunctions.item(object, index);
    }

    public static boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    public static boolean isFalse(Boolean b) {
        return b != null && b == false;
    }

    public static boolean isNotTrue(Boolean b) {
        return b == null || b == false;
    }

    public static boolean isNotFalse(Boolean b) {
        return b == null || b != false;
    }

    public static Boolean not(Boolean b) {
        return b == null ? null : Boolean.valueOf(b == false);
    }

    public static List arrayToList(Array a) {
        if (a == null) {
            return null;
        }
        try {
            return Primitive.asList(a.getArray());
        }
        catch (SQLException e) {
            throw Util.toUnchecked(e);
        }
    }

    @NonDeterministic
    public static long sequenceCurrentValue(String key) {
        return SqlFunctions.getAtomicLong(key).get();
    }

    @NonDeterministic
    public static long sequenceNextValue(String key) {
        return SqlFunctions.getAtomicLong(key).incrementAndGet();
    }

    private static AtomicLong getAtomicLong(String key) {
        Map<String, AtomicLong> map = THREAD_SEQUENCES.get();
        AtomicLong atomic = map.get(key);
        if (atomic == null) {
            atomic = new AtomicLong();
            map.put(key, atomic);
        }
        return atomic;
    }

    public static List slice(List list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object e : list) {
            result.add(SqlFunctions.structAccess(e, 0, null));
        }
        return result;
    }

    public static Object element(List list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw Static.RESOURCE.moreThanOneValueInList(list.toString()).ex();
    }

    public static boolean memberOf(Object object, Collection collection) {
        return collection.contains(object);
    }

    public static <E> Collection<E> multisetIntersectDistinct(Collection<E> c1, Collection<E> c2) {
        HashSet<E> result = new HashSet<E>(c1);
        result.retainAll(c2);
        return new ArrayList<E>(result);
    }

    public static <E> Collection<E> multisetIntersectAll(Collection<E> c1, Collection<E> c2) {
        ArrayList<E> result = new ArrayList<E>(c1.size());
        ArrayList<E> c2Copy = new ArrayList<E>(c2);
        for (E e : c1) {
            if (!c2Copy.remove(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> Collection<E> multisetExceptAll(Collection<E> c1, Collection<E> c2) {
        LinkedList<E> result = new LinkedList<E>(c1);
        for (E e : c2) {
            result.remove(e);
        }
        return result;
    }

    public static <E> Collection<E> multisetExceptDistinct(Collection<E> c1, Collection<E> c2) {
        HashSet<E> result = new HashSet<E>(c1);
        result.removeAll(c2);
        return new ArrayList<E>(result);
    }

    public static boolean isASet(Collection collection) {
        if (collection instanceof Set) {
            return true;
        }
        HashSet set = new HashSet(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        for (Object e : collection) {
            if (set.add(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean submultisetOf(Collection possibleSubMultiset, Collection multiset) {
        if (possibleSubMultiset.size() > multiset.size()) {
            return false;
        }
        LinkedList multisetLocal = new LinkedList(multiset);
        for (Object e : possibleSubMultiset) {
            if (multisetLocal.remove(e)) continue;
            return false;
        }
        return true;
    }

    public static Collection multisetUnionDistinct(Collection collection1, Collection collection2) {
        HashSet resultCollection = new HashSet(Math.max((int)((float)(collection1.size() + collection2.size()) / 0.75f) + 1, 16));
        resultCollection.addAll(collection1);
        resultCollection.addAll(collection2);
        return new ArrayList(resultCollection);
    }

    public static Collection multisetUnionAll(Collection collection1, Collection collection2) {
        ArrayList resultCollection = new ArrayList(collection1.size() + collection2.size());
        resultCollection.addAll(collection1);
        resultCollection.addAll(collection2);
        return resultCollection;
    }

    public static Function1<Object, Enumerable<FlatLists.ComparableList<Comparable>>> flatProduct(int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        if (fieldCounts.length == 1) {
            if (!withOrdinality && inputTypes[0] == FlatProductInputType.SCALAR) {
                return LIST_AS_ENUMERABLE;
            }
            return row -> SqlFunctions.p2(new Object[]{row}, fieldCounts, withOrdinality, inputTypes);
        }
        return lists -> SqlFunctions.p2((Object[])lists, fieldCounts, withOrdinality, inputTypes);
    }

    private static Enumerable<FlatLists.ComparableList<Comparable>> p2(Object[] lists, int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        ArrayList<Enumerator<List<Enumerator<List<Object>>>>> enumerators = new ArrayList<Enumerator<List<Enumerator<List<Object>>>>>();
        int totalFieldCount = 0;
        for (int i = 0; i < lists.length; ++i) {
            int fieldCount = fieldCounts[i];
            FlatProductInputType inputType = inputTypes[i];
            Object inputObject = lists[i];
            switch (inputType) {
                case SCALAR: {
                    List list = (List)inputObject;
                    enumerators.add(Linq4j.transform(Linq4j.enumerator(list), FlatLists::of));
                    break;
                }
                case LIST: {
                    List listList = (List)inputObject;
                    enumerators.add(Linq4j.enumerator(listList));
                    break;
                }
                case MAP: {
                    Map map = (Map)inputObject;
                    Enumerator enumerator = Linq4j.enumerator(map.entrySet());
                    Enumerator<List> transformed = Linq4j.transform(enumerator, e -> FlatLists.of(e.getKey(), e.getValue()));
                    enumerators.add(transformed);
                    break;
                }
            }
            if (fieldCount < 0) {
                ++totalFieldCount;
                continue;
            }
            totalFieldCount += fieldCount;
        }
        if (withOrdinality) {
            ++totalFieldCount;
        }
        return SqlFunctions.product(enumerators, totalFieldCount, withOrdinality);
    }

    public static Object[] array(Object ... args) {
        return args;
    }

    public static <E extends Comparable> Enumerable<FlatLists.ComparableList<E>> product(final List<Enumerator<List<E>>> enumerators, final int fieldCount, final boolean withOrdinality) {
        return new AbstractEnumerable<FlatLists.ComparableList<E>>(){

            @Override
            public Enumerator<FlatLists.ComparableList<E>> enumerator() {
                return new ProductComparableListEnumerator(enumerators, fieldCount, withOrdinality);
            }
        };
    }

    public static long addMonths(long timestamp, int m3) {
        long millis = DateTimeUtils.floorMod(timestamp, 86400000L);
        long x = SqlFunctions.addMonths((int)((timestamp -= millis) / 86400000L), m3);
        return x * 86400000L + millis;
    }

    public static int addMonths(int date, int m3) {
        int y;
        int last;
        int y0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.YEAR, date);
        int m0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.MONTH, date);
        int d0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.DAY, date);
        if (d0 > (last = SqlFunctions.lastDay(y0 += (y = m3 / 12), m0 += m3 - y * 12))) {
            d0 = last;
        }
        return DateTimeUtils.ymdToUnixDate(y0, m0, d0);
    }

    private static int lastDay(int y, int m3) {
        switch (m3) {
            case 2: {
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static int subtractMonths(int date0, int date1) {
        if (date0 < date1) {
            return -SqlFunctions.subtractMonths(date1, date0);
        }
        int m3 = (date0 - date1) / 31;
        int date2;
        while ((date2 = SqlFunctions.addMonths(date1, m3)) < date0) {
            int date3 = SqlFunctions.addMonths(date1, m3 + 1);
            if (date3 > date0) {
                return m3;
            }
            ++m3;
        }
        return m3;
    }

    public static int subtractMonths(long t0, long t1) {
        int x;
        long millis0 = DateTimeUtils.floorMod(t0, 86400000L);
        int d0 = (int)DateTimeUtils.floorDiv(t0 - millis0, 86400000L);
        long millis1 = DateTimeUtils.floorMod(t1, 86400000L);
        int d1 = (int)DateTimeUtils.floorDiv(t1 - millis1, 86400000L);
        long d2 = SqlFunctions.addMonths(d1, x = SqlFunctions.subtractMonths(d0, d1));
        if (d2 == (long)d0 && millis0 < millis1) {
            --x;
        }
        return x;
    }

    public static Object structAccess(Object structObject, int index, String fieldName) {
        if (structObject == null) {
            return null;
        }
        if (structObject instanceof Object[]) {
            return ((Object[])structObject)[index];
        }
        if (structObject instanceof List) {
            return ((List)structObject).get(index);
        }
        if (structObject instanceof Row) {
            return ((Row)structObject).getObject(index);
        }
        Class<?> beanClass = structObject.getClass();
        try {
            Field structField = beanClass.getDeclaredField(fieldName);
            return structField.get(structObject);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw Static.RESOURCE.failedToAccessField(fieldName, beanClass.getName()).ex(ex);
        }
    }

    public static enum FlatProductInputType {
        SCALAR,
        LIST,
        MAP;

    }

    private static class ProductComparableListEnumerator<E extends Comparable>
    extends CartesianProductEnumerator<List<E>, FlatLists.ComparableList<E>> {
        final E[] flatElements;
        final List<E> list;
        private final boolean withOrdinality;
        private int ordinality;

        ProductComparableListEnumerator(List<Enumerator<List<E>>> enumerators, int fieldCount, boolean withOrdinality) {
            super(enumerators);
            this.withOrdinality = withOrdinality;
            this.flatElements = new Comparable[fieldCount];
            this.list = Arrays.asList(this.flatElements);
        }

        @Override
        public FlatLists.ComparableList<E> current() {
            int i = 0;
            for (Object element : this.elements) {
                Object[] a;
                if (element.getClass().isArray()) {
                    a = (Object[])element;
                } else {
                    List list2 = (List)element;
                    a = list2.toArray();
                }
                System.arraycopy(a, 0, this.flatElements, i, a.length);
                i += a.length;
            }
            if (this.withOrdinality) {
                this.flatElements[i] = ++this.ordinality;
            }
            return FlatLists.ofComparable(this.list);
        }
    }
}

