/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.apache.calcite.util.ImmutableBitSet;

public class Automaton {
    final State startState;
    final State endState;
    private final ImmutableList<SymbolTransition> transitions;
    private final ImmutableList<EpsilonTransition> epsilonTransitions;
    final ImmutableList<String> symbolNames;

    Automaton(State startState, State endState, ImmutableList<SymbolTransition> transitions, ImmutableList<EpsilonTransition> epsilonTransitions, ImmutableList<String> symbolNames) {
        this.startState = Objects.requireNonNull(startState);
        this.endState = Objects.requireNonNull(endState);
        this.transitions = Objects.requireNonNull(transitions);
        this.epsilonTransitions = epsilonTransitions;
        this.symbolNames = Objects.requireNonNull(symbolNames);
    }

    void successors(int fromState, int symbol, ImmutableBitSet.Builder bitSet) {
        for (SymbolTransition transition : this.transitions) {
            if (transition.fromState.id != fromState || transition.symbol != symbol) continue;
            this.epsilonSuccessors(transition.toState.id, bitSet);
        }
    }

    void epsilonSuccessors(int state, ImmutableBitSet.Builder bitSet) {
        bitSet.set(state);
        for (EpsilonTransition transition : this.epsilonTransitions) {
            if (transition.fromState.id != state || bitSet.get(transition.toState.id)) continue;
            this.epsilonSuccessors(transition.toState.id, bitSet);
        }
    }

    public ImmutableList<SymbolTransition> getTransitions() {
        return this.transitions;
    }

    public ImmutableList<EpsilonTransition> getEpsilonTransitions() {
        return this.epsilonTransitions;
    }

    static class EpsilonTransition
    extends Transition {
        EpsilonTransition(State fromState, State toState) {
            super(fromState, toState);
        }

        public String toString() {
            return "epsilon:" + this.fromState.id + "->" + this.toState.id;
        }
    }

    static class SymbolTransition
    extends Transition {
        final int symbol;

        SymbolTransition(State fromState, State toState, int symbol) {
            super(fromState, toState);
            this.symbol = symbol;
        }

        public String toString() {
            return this.symbol + ":" + this.fromState.id + "->" + this.toState.id;
        }
    }

    static abstract class Transition {
        final State fromState;
        final State toState;

        Transition(State fromState, State toState) {
            this.fromState = Objects.requireNonNull(fromState);
            this.toState = Objects.requireNonNull(toState);
        }
    }

    static class State {
        final int id;

        State(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof State && ((State)o).id == this.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return "State{id=" + this.id + '}';
        }
    }
}

