/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.tools.RelBuilderFactory;

public class SortJoinCopyRule
extends RelOptRule {
    public static final SortJoinCopyRule INSTANCE = new SortJoinCopyRule(LogicalSort.class, Join.class, RelFactories.LOGICAL_BUILDER);

    protected SortJoinCopyRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        super(SortJoinCopyRule.operand(sortClass, SortJoinCopyRule.operand(joinClass, SortJoinCopyRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode newRightInput;
        RelNode newLeftInput;
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        RelMetadataQuery metadataQuery = call.getMetadataQuery();
        ArrayList<RelFieldCollation> leftFieldCollation = new ArrayList<RelFieldCollation>();
        ArrayList<RelFieldCollation> rightFieldCollation = new ArrayList<RelFieldCollation>();
        for (RelFieldCollation relFieldCollation : sort.getCollation().getFieldCollations()) {
            if (relFieldCollation.getFieldIndex() >= join.getLeft().getRowType().getFieldCount()) {
                rightFieldCollation.add(relFieldCollation);
                continue;
            }
            leftFieldCollation.add(relFieldCollation);
        }
        if (leftFieldCollation.isEmpty()) {
            newLeftInput = join.getLeft();
        } else {
            RelCollation leftCollation = RelCollationTraitDef.INSTANCE.canonize(RelCollations.of(leftFieldCollation));
            newLeftInput = RelMdUtil.checkInputForCollationAndLimit(metadataQuery, join.getLeft(), leftCollation, null, null) ? join.getLeft() : sort.copy(sort.getTraitSet().replaceIf(RelCollationTraitDef.INSTANCE, () -> leftCollation), join.getLeft(), leftCollation, null, null);
        }
        if (rightFieldCollation.isEmpty()) {
            newRightInput = join.getRight();
        } else {
            RelCollation rightCollation = RelCollationTraitDef.INSTANCE.canonize(RelCollations.shift(RelCollations.of(rightFieldCollation), -join.getLeft().getRowType().getFieldCount()));
            newRightInput = RelMdUtil.checkInputForCollationAndLimit(metadataQuery, join.getRight(), rightCollation, null, null) ? join.getRight() : sort.copy(sort.getTraitSet().replaceIf(RelCollationTraitDef.INSTANCE, () -> rightCollation), join.getRight(), rightCollation, null, null);
        }
        if (newLeftInput == join.getLeft() && newRightInput == join.getRight()) {
            return;
        }
        Join joinCopy = join.copy(join.getTraitSet(), join.getCondition(), newLeftInput, newRightInput, join.getJoinType(), join.isSemiJoinDone());
        Sort sortCopy = sort.copy(sort.getTraitSet(), joinCopy, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(sortCopy);
    }
}

