/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.trino2rel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.linkedin.coral.common.calcite.CalciteUtil;
import com.linkedin.coral.trino.trino2rel.Trino2CoralOperatorTransformerMapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

class OperatorTransformer {
    private static final Map<String, SqlOperator> OP_MAP = new HashMap<String, SqlOperator>();
    public static final String OPERATOR = "op";
    public static final String OPERANDS = "operands";
    public static final String INPUT = "input";
    public static final String VALUE = "value";
    public static final String REGEX = "regex";
    public static final String NAME = "name";
    public final String fromOperatorName;
    public final SqlOperator targetOperator;
    public final List<JsonObject> operandTransformers;
    public final JsonObject resultTransformer;
    public final List<JsonObject> operatorTransformers;

    private OperatorTransformer(String fromOperatorName, SqlOperator targetOperator, List<JsonObject> operandTransformers, JsonObject resultTransformer, List<JsonObject> operatorTransformers) {
        this.fromOperatorName = fromOperatorName;
        this.targetOperator = targetOperator;
        this.operandTransformers = operandTransformers;
        this.resultTransformer = resultTransformer;
        this.operatorTransformers = operatorTransformers;
    }

    public static OperatorTransformer of(@Nonnull String fromOperatorName, @Nonnull SqlOperator targetOperator, @Nullable String operandTransformers, @Nullable String resultTransformer, @Nullable String operatorTransformers) {
        List<JsonObject> operands = null;
        JsonObject result = null;
        List<JsonObject> operators = null;
        if (operandTransformers != null) {
            operands = OperatorTransformer.parseJsonObjectsFromString(operandTransformers);
        }
        if (resultTransformer != null) {
            result = new JsonParser().parse(resultTransformer).getAsJsonObject();
        }
        if (operatorTransformers != null) {
            operators = OperatorTransformer.parseJsonObjectsFromString(operatorTransformers);
        }
        return new OperatorTransformer(fromOperatorName, targetOperator, operands, result, operators);
    }

    public SqlNode transformCall(List<SqlNode> sourceOperands) {
        SqlOperator newTargetOperator = this.transformTargetOperator(this.targetOperator, sourceOperands);
        if (newTargetOperator == null || newTargetOperator.getName().isEmpty()) {
            String operands = sourceOperands.stream().map(SqlNode::toString).collect(Collectors.joining(","));
            throw new IllegalArgumentException(String.format("An equivalent operator in the target IR was not found for the function call: %s(%s)", this.fromOperatorName, operands));
        }
        List<SqlNode> newOperands = this.transformOperands(sourceOperands);
        SqlCall newCall = CalciteUtil.createCall(newTargetOperator, newOperands, SqlParserPos.ZERO);
        return this.transformResult(newCall, sourceOperands);
    }

    private List<SqlNode> transformOperands(List<SqlNode> sourceOperands) {
        if (this.operandTransformers == null) {
            return sourceOperands;
        }
        ArrayList<SqlNode> sources = new ArrayList<SqlNode>();
        sources.add(null);
        sources.addAll(sourceOperands);
        ArrayList<SqlNode> results = new ArrayList<SqlNode>();
        for (JsonObject operandTransformer : this.operandTransformers) {
            results.add(this.transformExpression(operandTransformer, sources));
        }
        return results;
    }

    private SqlNode transformResult(SqlNode result, List<SqlNode> sourceOperands) {
        if (this.resultTransformer == null) {
            return result;
        }
        ArrayList<SqlNode> sources = new ArrayList<SqlNode>();
        sources.add(result);
        sources.addAll(sourceOperands);
        return this.transformExpression(this.resultTransformer, sources);
    }

    private SqlNode transformExpression(JsonObject transformer, List<SqlNode> sourceOperands) {
        if (transformer.get(OPERATOR) != null) {
            ArrayList<SqlNode> inputOperands = new ArrayList<SqlNode>();
            for (JsonElement inputOperand : transformer.getAsJsonArray(OPERANDS)) {
                if (!inputOperand.isJsonObject()) continue;
                inputOperands.add(this.transformExpression(inputOperand.getAsJsonObject(), sourceOperands));
            }
            String operatorName = transformer.get(OPERATOR).getAsString();
            SqlOperator op = OP_MAP.get(operatorName);
            if (op == null) {
                throw new UnsupportedOperationException("Operator " + operatorName + " is not supported in transformation");
            }
            return CalciteUtil.createCall(op, inputOperands, SqlParserPos.ZERO);
        }
        if (transformer.get(INPUT) != null) {
            int index = transformer.get(INPUT).getAsInt();
            if (index < 0 || index >= sourceOperands.size() || sourceOperands.get(index) == null) {
                throw new IllegalArgumentException("Invalid input value: " + index + ". Number of source operands: " + sourceOperands.size());
            }
            return sourceOperands.get(index);
        }
        JsonElement value = transformer.get(VALUE);
        if (value == null) {
            throw new IllegalArgumentException("JSON node for transformation should be either op, input, or value");
        }
        if (!value.isJsonPrimitive()) {
            throw new IllegalArgumentException("Value should be of primitive type: " + value);
        }
        JsonPrimitive primitive = value.getAsJsonPrimitive();
        if (primitive.isString()) {
            return CalciteUtil.createStringLiteral(primitive.getAsString(), SqlParserPos.ZERO);
        }
        if (primitive.isBoolean()) {
            return CalciteUtil.createLiteralBoolean(primitive.getAsBoolean(), SqlParserPos.ZERO);
        }
        if (primitive.isNumber()) {
            return CalciteUtil.createLiteralNumber(value.getAsBigDecimal().longValue(), SqlParserPos.ZERO);
        }
        throw new UnsupportedOperationException("Invalid JSON literal value: " + primitive);
    }

    private SqlOperator transformTargetOperator(SqlOperator operator, List<SqlNode> sourceOperands) {
        if (this.operatorTransformers == null) {
            return operator;
        }
        for (JsonObject operatorTransformer : this.operatorTransformers) {
            if (!(operatorTransformer.has(REGEX) && operatorTransformer.has(INPUT) && operatorTransformer.has(NAME))) {
                throw new IllegalArgumentException("JSON node for target operator transformer must have a matcher, input and name");
            }
            int index = operatorTransformer.get(INPUT).getAsInt() - 1;
            if (index < 0 || index >= sourceOperands.size()) {
                throw new IllegalArgumentException(String.format("Index is not within the acceptable range [%d, %d]", 1, sourceOperands.size()));
            }
            String functionName = operatorTransformer.get(NAME).getAsString();
            if (functionName.isEmpty()) {
                throw new IllegalArgumentException("JSON node for transformation must have a non-empty name");
            }
            String matcher = operatorTransformer.get(REGEX).getAsString();
            if (!Pattern.matches(matcher, sourceOperands.get(index).toString())) continue;
            return Trino2CoralOperatorTransformerMapUtils.createOperator(functionName, operator.getReturnTypeInference(), null);
        }
        return operator;
    }

    private static List<JsonObject> parseJsonObjectsFromString(String s2) {
        ArrayList<JsonObject> objects = new ArrayList<JsonObject>();
        JsonArray transformerArray = new JsonParser().parse(s2).getAsJsonArray();
        for (JsonElement object : transformerArray) {
            objects.add(object.getAsJsonObject());
        }
        return objects;
    }

    static {
        OP_MAP.put("+", SqlStdOperatorTable.PLUS);
        OP_MAP.put("-", SqlStdOperatorTable.MINUS);
        OP_MAP.put("*", SqlStdOperatorTable.MULTIPLY);
        OP_MAP.put("/", SqlStdOperatorTable.DIVIDE);
        OP_MAP.put("^", SqlStdOperatorTable.POWER);
        OP_MAP.put("%", SqlStdOperatorTable.MOD);
    }
}

