/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.HiveTypeSystem;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import com.linkedin.coral.common.utils.TypeDerivationUtil;
import com.linkedin.coral.hive.hive2rel.functions.HiveNamedStructFunction;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlArrayTypeSpec;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlRowTypeSpec;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class NamedStructToCastTransformer
extends SqlCallTransformer {
    public NamedStructToCastTransformer(TypeDerivationUtil typeDerivationUtil) {
        super(typeDerivationUtil);
    }

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().equals(HiveNamedStructFunction.NAMED_STRUCT);
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        List<SqlNode> inputOperands = sqlCall.getOperandList();
        ArrayList<SqlDataTypeSpec> rowTypes = new ArrayList<SqlDataTypeSpec>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < inputOperands.size(); i += 2) {
            assert (inputOperands.get(i) instanceof SqlLiteral);
            fieldNames.add(((SqlLiteral)inputOperands.get(i)).getStringValue());
        }
        ArrayList<SqlNode> rowCallOperands = new ArrayList<SqlNode>();
        for (int i = 1; i < inputOperands.size(); i += 2) {
            rowCallOperands.add(inputOperands.get(i));
            RelDataType type = this.deriveRelDatatype(inputOperands.get(i));
            SqlDataTypeSpec sqlDataTypeSpec = SqlTypeUtil.convertTypeToSpec(type);
            if (sqlDataTypeSpec instanceof SqlArrayTypeSpec && ((SqlArrayTypeSpec)sqlDataTypeSpec).getElementTypeSpec().toString().equalsIgnoreCase("null")) {
                int defaultVarcharPrecision = new HiveTypeSystem().getDefaultPrecision(SqlTypeName.VARCHAR);
                sqlDataTypeSpec = new SqlArrayTypeSpec(new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.VARCHAR, defaultVarcharPrecision, SqlParserPos.ZERO), SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
            rowTypes.add(sqlDataTypeSpec);
        }
        SqlCall rowCall = SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, rowCallOperands);
        return new SqlCastFunction(){

            @Override
            public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
                SqlCallBinding opBinding = new SqlCallBinding(validator, scope, call);
                return this.inferReturnType(opBinding);
            }
        }.createCall(SqlParserPos.ZERO, rowCall, new SqlRowTypeSpec(fieldNames, rowTypes, SqlParserPos.ZERO));
    }
}

