/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino;

import com.google.common.base.Preconditions;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableMap;
import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.common.functions.CoralSqlUnnestOperator;
import com.linkedin.coral.common.functions.FunctionFieldReferenceOperator;
import com.linkedin.coral.trino.rel2trino.Calcite2TrinoUDFConverter;
import com.linkedin.coral.trino.rel2trino.CoralToTrinoSqlCallConverter;
import com.linkedin.coral.trino.rel2trino.DataTypeDerivedSqlCallConverter;
import com.linkedin.coral.trino.rel2trino.TrinoSqlDialect;
import com.linkedin.coral.trino.rel2trino.TrinoSqlRewriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class RelToTrinoConverter
extends RelToSqlConverter {
    private Map<String, Boolean> configs = new HashMap<String, Boolean>();
    private HiveMetastoreClient _hiveMetastoreClient;

    public RelToTrinoConverter(HiveMetastoreClient mscClient) {
        super(TrinoSqlDialect.INSTANCE);
        this._hiveMetastoreClient = mscClient;
    }

    public RelToTrinoConverter(HiveMetastoreClient mscClient, Map<String, Boolean> configs) {
        super(TrinoSqlDialect.INSTANCE);
        Preconditions.checkNotNull(configs);
        this.configs = configs;
        this._hiveMetastoreClient = mscClient;
    }

    public String convert(RelNode relNode) {
        RelNode rel = Calcite2TrinoUDFConverter.convertRel(relNode, this.configs);
        SqlNode sqlNode = this.convertToSqlNode(rel);
        SqlNode sqlNodeWithRelDataTypeDerivedConversions = sqlNode.accept(new DataTypeDerivedSqlCallConverter(this._hiveMetastoreClient, sqlNode));
        SqlNode sqlNodeWithUDFOperatorConverted = sqlNodeWithRelDataTypeDerivedConversions.accept(new CoralToTrinoSqlCallConverter(this.configs));
        return sqlNodeWithUDFOperatorConverted.accept(new TrinoSqlRewriter()).toSqlString(TrinoSqlDialect.INSTANCE).toString();
    }

    public SqlNode convertToSqlNode(RelNode relNode) {
        return this.visitChild(0, relNode).asStatement();
    }

    public SqlImplementor.Result visit(Window window) {
        return null;
    }

    @Override
    public SqlImplementor.Result visit(Project e) {
        e.getVariablesSet();
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        this.parseCorrelTable(e, x);
        if (RelToTrinoConverter.isStar(e.getChildExps(), e.getInput().getRowType(), e.getRowType())) {
            return x;
        }
        SqlImplementor.Builder builder = x.builder(e, SqlImplementor.Clause.SELECT);
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        for (RexNode ref : e.getChildExps()) {
            SqlNode sqlExpr = builder.context.toSql(null, ref);
            RelDataTypeField targetField = e.getRowType().getFieldList().get(selectList.size());
            if (SqlUtil.isNullLiteral(sqlExpr, false) && !((RelDataType)targetField.getValue()).getSqlTypeName().equals((Object)SqlTypeName.NULL)) {
                sqlExpr = SqlStdOperatorTable.CAST.createCall(POS, sqlExpr, this.dialect.getCastSpec(targetField.getType()));
            }
            this.addSelect(selectList, sqlExpr, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        return builder.result();
    }

    @Override
    public SqlImplementor.Result visit(Uncollect e) {
        SqlImplementor.Result projectResult = this.visitChild(0, e.getInput());
        ArrayList<SqlNode> unnestOperands = new ArrayList<SqlNode>();
        RelDataType recordType = null;
        boolean withOrdinality = e.withOrdinality;
        for (RexNode unnestCol : ((Project)e.getInput()).getChildExps()) {
            unnestOperands.add(projectResult.qualifiedContext().toSql(null, unnestCol));
            if (!unnestCol.getType().getSqlTypeName().equals((Object)SqlTypeName.ARRAY) || !unnestCol.getType().getComponentType().getSqlTypeName().equals((Object)SqlTypeName.ROW)) continue;
            recordType = unnestCol.getType().getComponentType();
        }
        SqlCall unnestCall = new CoralSqlUnnestOperator(withOrdinality, recordType).createCall(POS, unnestOperands.toArray(new SqlNode[0]));
        return new SqlImplementor.Result(this, unnestCall, ImmutableList.of(SqlImplementor.Clause.FROM), null, e.getRowType(), ImmutableMap.of(projectResult.neededAlias, e.getRowType()));
    }

    @Override
    public SqlImplementor.Result visit(TableScan e) {
        List<String> qualifiedName = e.getTable().getQualifiedName();
        if (qualifiedName.size() > 2) {
            qualifiedName = qualifiedName.subList(qualifiedName.size() - 2, qualifiedName.size());
        }
        SqlIdentifier identifier = new SqlIdentifier(qualifiedName, SqlParserPos.ZERO);
        return this.result(identifier, ImmutableList.of(SqlImplementor.Clause.FROM), e, null);
    }

    private boolean isTrinoSupportedUnnest(Uncollect uncollect) {
        if (!(uncollect.getInput() instanceof Project) || !(((Project)uncollect.getInput()).getInput() instanceof Values)) {
            return false;
        }
        Values values = (Values)((Project)uncollect.getInput()).getInput();
        if (values.getTuples().size() == 1 && ((ImmutableList)values.getTuples().get(0)).size() == 1) {
            RexLiteral val = (RexLiteral)((ImmutableList)values.getTuples().get(0)).get(0);
            return val.getValue().equals(new BigDecimal(0));
        }
        return false;
    }

    @Override
    public SqlImplementor.Result visit(Join e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft()).resetAlias();
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight()).resetAlias();
        SqlImplementor.Context leftContext = leftResult.qualifiedContext();
        SqlImplementor.Context rightContext = rightResult.qualifiedContext();
        SqlNode sqlCondition = null;
        SqlLiteral condType = JoinConditionType.ON.symbol(POS);
        JoinType joinType = RelToTrinoConverter.joinType(e.getJoinType());
        if (e.getJoinType() == JoinRelType.INNER && e.getCondition().isAlwaysTrue()) {
            joinType = this.dialect.emulateJoinTypeForCrossJoin();
            condType = JoinConditionType.NONE.symbol(POS);
        } else {
            sqlCondition = this.convertConditionToSqlNode(e.getCondition(), leftContext, rightContext, e.getLeft().getRowType().getFieldCount());
        }
        SqlNode rightSqlNode = rightResult.asFrom();
        if (e.getRight() instanceof LogicalTableFunctionScan || e.getRight() instanceof Uncollect) {
            rightSqlNode = this.generateRightChildForSqlJoinWithLateralViews(e, rightResult);
        }
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), joinType.symbol(POS), rightSqlNode, condType, sqlCondition);
        return this.result(join, leftResult, rightResult);
    }

    @Override
    public SqlImplementor.Result visit(Correlate e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft()).resetAlias();
        this.correlTableMap.put(e.getCorrelationId(), leftResult.qualifiedContext());
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight()).resetAlias();
        SqlNode rightSqlNode = this.generateRightChildForSqlJoinWithLateralViews(e, rightResult);
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), JoinType.COMMA.symbol(POS), rightSqlNode, JoinConditionType.NONE.symbol(POS), null);
        return this.result(join, leftResult, rightResult);
    }

    private SqlNode generateRightChildForSqlJoinWithLateralViews(BiRel e, SqlImplementor.Result rightResult) {
        SqlNode rightSqlNode = rightResult.asFrom();
        SqlCall lateralNode = rightSqlNode instanceof SqlCall && ((SqlCall)rightSqlNode).getOperator().kind == SqlKind.AS ? SqlStdOperatorTable.LATERAL.createCall(POS, new SqlNode[]{((SqlCall)rightSqlNode).operand(0)}) : SqlStdOperatorTable.LATERAL.createCall(POS, rightSqlNode);
        RelDataType relDataType = e.getRight().getRowType();
        String alias = rightResult.aliases.entrySet().stream().filter(entry -> relDataType.equals(entry.getValue())).findFirst().map(Map.Entry::getKey).orElse("coralDefaultColumnAlias");
        List<SqlNode> asOperands = this.createAsFullOperands(relDataType, lateralNode, alias);
        return SqlStdOperatorTable.AS.createCall(POS, asOperands);
    }

    @Override
    public SqlImplementor.Result visit(Values e) {
        SqlImplementor.Result originalResult = super.visit(e);
        return new SqlImplementor.Result(this, originalResult.node, originalResult.clauses, null, originalResult.neededType, originalResult.aliases);
    }

    @Override
    public SqlImplementor.Context aliasContext(Map<String, RelDataType> aliases, boolean qualified) {
        return new SqlImplementor.AliasContext((SqlDialect)TrinoSqlDialect.INSTANCE, aliases, qualified){

            @Override
            public SqlNode toSql(RexProgram program, RexNode rex) {
                if (rex.getKind() == SqlKind.FIELD_ACCESS) {
                    ArrayList<String> accessNames = new ArrayList<String>();
                    RexNode referencedExpr = rex;
                    while (referencedExpr.getKind() == SqlKind.FIELD_ACCESS) {
                        accessNames.add(((RexFieldAccess)referencedExpr).getField().getName());
                        referencedExpr = ((RexFieldAccess)referencedExpr).getReferenceExpr();
                    }
                    if (referencedExpr.getKind() == SqlKind.OTHER_FUNCTION) {
                        SqlNode functionCall = this.toSql(program, referencedExpr);
                        Collections.reverse(accessNames);
                        for (String accessName : accessNames) {
                            functionCall = FunctionFieldReferenceOperator.DOT.createCall(SqlParserPos.ZERO, functionCall, new SqlIdentifier(accessName, SqlImplementor.POS));
                        }
                        return functionCall;
                    }
                }
                return super.toSql(program, rex);
            }
        };
    }
}

