/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class HiveRLikeOperator
extends SqlSpecialOperator {
    public static final HiveRLikeOperator RLIKE = new HiveRLikeOperator("RLIKE", false);
    public static final HiveRLikeOperator REGEXP = new HiveRLikeOperator("REGEXP", false);
    private final boolean negated;

    public HiveRLikeOperator(String name, boolean negated) {
        super(name, SqlKind.OTHER_FUNCTION, 32, false, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME);
        this.negated = negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return OperandTypes.STRING_SAME_SAME.checkOperandTypes(callBinding, throwOnFailure) && SqlTypeUtil.isCharTypeComparable(callBinding, callBinding.operands(), throwOnFailure);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.sep(this.getName());
        ((SqlNode)call.operand(1)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.endList(frame);
    }
}

