/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class SameOperandTypeExceptFirstOperandChecker
extends SameOperandTypeChecker {
    protected final SqlTypeName firstOperandTypeName;

    public SameOperandTypeExceptFirstOperandChecker(int nOperands, SqlTypeName firstOperandTypeName) {
        super(nOperands);
        this.firstOperandTypeName = firstOperandTypeName;
    }

    @Override
    protected boolean checkOperandTypesImpl(SqlOperatorBinding opBinding, boolean throwOnFailure, SqlCallBinding callBinding) {
        int actualOperands = this.nOperands;
        if (actualOperands == -1) {
            actualOperands = opBinding.getOperandCount();
        }
        Preconditions.checkState((!throwOnFailure || callBinding != null ? 1 : 0) != 0);
        RelDataType[] types = new RelDataType[actualOperands];
        List<Integer> operandList = this.getOperandList(opBinding.getOperandCount());
        for (Integer i : operandList) {
            types[i.intValue()] = opBinding.getOperandType(i);
        }
        if (!types[0].getSqlTypeName().equals((Object)this.firstOperandTypeName)) {
            return this.handleError(callBinding, throwOnFailure);
        }
        for (int i = 2; i < operandList.size(); ++i) {
            if (this.isComparableWithNullable(types[i - 1], types[i])) continue;
            this.handleError(callBinding, throwOnFailure);
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        String typeName = this.getTypeName();
        if (this.nOperands == -1) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of((Object)"...", (Object)typeName, (Object)typeName));
        }
        ImmutableList types = new ImmutableList.Builder().add((Object)this.firstOperandTypeName).addAll(Collections.nCopies(this.nOperands - 1, typeName)).build();
        return SqlUtil.getAliasedSignature(op, opName, types);
    }

    private boolean handleError(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    private boolean isComparableWithNullable(RelDataType type1, RelDataType type2) {
        return type1.getSqlTypeName() == SqlTypeName.NULL || type2.getSqlTypeName() == SqlTypeName.NULL || SqlTypeUtil.isComparable(type1, type2);
    }
}

