/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common.calcite;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CalciteUtil.class);
    public static final SqlParser.Config SQL_PARSER_CONFIG = SqlParser.configBuilder().setCaseSensitive(false).setUnquotedCasing(Casing.UNCHANGED).setQuotedCasing(Casing.UNCHANGED).setConformance(SqlConformanceEnum.ORACLE_10).build();

    public static SqlNode parseStatement(String query) throws SqlParseException {
        String quotedQuery = CalciteUtil.quoteReservedWords(query);
        try {
            String expression = "(" + quotedQuery + ")";
            SqlParser sqlParser = SqlParser.create(expression, SQL_PARSER_CONFIG);
            return sqlParser.parseExpression();
        }
        catch (SqlParseException e) {
            return CalciteUtil.parseQuery(quotedQuery);
        }
    }

    private static SqlNode parseQuery(String query) throws SqlParseException {
        try {
            SqlParser sqlParser = SqlParser.create(query);
            return sqlParser.parseQuery();
        }
        catch (SqlParseException e) {
            LOG.error("Failed to parse query: {}", (Object)query);
            throw e;
        }
    }

    public static SqlNode createLiteralNumber(long value, SqlParserPos pos) {
        return SqlLiteral.createExactNumeric(String.valueOf(value), pos);
    }

    public static String convertScientificDouble(double value) {
        String valueString = String.valueOf(value);
        if (valueString.toUpperCase().contains("E")) {
            int index = valueString.indexOf("E-") > 0 ? valueString.indexOf("E-") + 2 : valueString.indexOf("E") + 1;
            Integer scale = Integer.valueOf(valueString.substring(index));
            valueString = String.format("%." + String.format("%d", scale) + "f", value);
        }
        return valueString;
    }

    public static SqlNode createLiteralNumber(double value, SqlParserPos pos) {
        return SqlLiteral.createExactNumeric(CalciteUtil.convertScientificDouble(value), pos);
    }

    public static SqlLiteral createLiteralBoolean(boolean value, SqlParserPos pos) {
        return SqlLiteral.createBoolean(value, pos);
    }

    public static SqlNode createStringLiteral(String value, SqlParserPos pos) {
        return SqlLiteral.createCharString(value, pos);
    }

    public static SqlNode createBinaryLiteral(byte[] value, SqlParserPos pos) {
        return SqlLiteral.createBinaryString(value, pos);
    }

    public static SqlNode createLiteralNull(SqlParserPos pos) {
        return SqlLiteral.createNull(pos);
    }

    public static SqlCall createCall(SqlOperator sqlOperator, List<SqlNode> sqlNodeList) {
        return sqlOperator.createCall(CalciteUtil.createSqlNodeList(sqlNodeList));
    }

    public static SqlCall createCall(SqlOperator sqlOperator, List<SqlNode> sqlNodeList, SqlParserPos pos) {
        return sqlOperator.createCall(new SqlNodeList(sqlNodeList, pos));
    }

    public static SqlCall createCall(SqlOperator sqlOperator, List<SqlNode> sqlNodeList, SqlLiteral functionQuantifier) {
        return sqlOperator.createCall(functionQuantifier, SqlParserPos.ZERO, sqlNodeList.toArray(new SqlNode[0]));
    }

    public static String[] splitIdentifierString(String identifierString) {
        return identifierString.split("\\.");
    }

    public static SqlIdentifier createSqlIdentifier(SqlParserPos pos, String ... path) {
        return new SqlIdentifier(Arrays.asList(path), pos);
    }

    public static SqlIdentifier createStarIdentifier(SqlParserPos pos) {
        return CalciteUtil.createSqlIdentifier(pos, "");
    }

    public static SqlNodeList createSqlNodeList(Collection<SqlNode> sqlNodeList) {
        return new SqlNodeList(sqlNodeList, SqlParserPos.ZERO);
    }

    public static SqlNodeList createSqlNodeList(Collection<SqlNode> sqlNodeList, SqlParserPos pos) {
        return new SqlNodeList(sqlNodeList, pos);
    }

    public static String quoteReservedWords(String s2) {
        if (s2 == null) {
            return s2;
        }
        s2 = s2.replaceAll("(^|[^\"]\\b)time(\\b[^']|$)", "$1\"time\"$2");
        s2 = s2.replaceAll("(^|\\W)rank($|\\W)", "$1\"rank\"$2");
        return s2;
    }
}

