/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.google.common.base.Preconditions;
import com.linkedin.coral.common.CoralJavaTypeFactoryImpl;
import com.linkedin.coral.common.HiveUncollect;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;

public class HiveRelBuilder
extends RelBuilder {
    public static final RelBuilderFactory LOGICAL_BUILDER = HiveRelBuilder.proto(Contexts.of(RelFactories.DEFAULT_PROJECT_FACTORY, RelFactories.DEFAULT_FILTER_FACTORY, RelFactories.DEFAULT_JOIN_FACTORY, RelFactories.DEFAULT_SORT_FACTORY, RelFactories.DEFAULT_EXCHANGE_FACTORY, RelFactories.DEFAULT_SORT_EXCHANGE_FACTORY, RelFactories.DEFAULT_AGGREGATE_FACTORY, RelFactories.DEFAULT_MATCH_FACTORY, RelFactories.DEFAULT_SET_OP_FACTORY, RelFactories.DEFAULT_VALUES_FACTORY, RelFactories.DEFAULT_TABLE_SCAN_FACTORY, RelFactories.DEFAULT_SNAPSHOT_FACTORY, RelFactories.DEFAULT_SPOOL_FACTORY, RelFactories.DEFAULT_REPEAT_UNION_FACTORY));

    private HiveRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        super(context, cluster, relOptSchema);
    }

    public static RelBuilder create(FrameworkConfig config) {
        return Frameworks.withPrepare(config, (cluster, relOptSchema, rootSchema, statement) -> {
            cluster = RelOptCluster.create(cluster.getPlanner(), new RexBuilder(new CoralJavaTypeFactoryImpl(cluster.getTypeFactory().getTypeSystem())));
            return new HiveRelBuilder(config.getContext(), cluster, relOptSchema);
        });
    }

    public static RelBuilderFactory proto(Context context) {
        return (cluster, schema) -> new HiveRelBuilder(context, cluster, schema);
    }

    @Override
    public RelBuilder rename(List<String> fieldNames) {
        RelDataTypeFactory.FieldInfoBuilder b;
        List<String> oldFieldNames = this.peek().getRowType().getFieldNames();
        Preconditions.checkArgument((fieldNames.size() <= oldFieldNames.size() ? 1 : 0) != 0, (Object)"More names than fields");
        ArrayList<String> newFieldNames = new ArrayList<String>(oldFieldNames);
        for (int i = 0; i < fieldNames.size(); ++i) {
            String s2 = fieldNames.get(i);
            if (s2 == null) continue;
            newFieldNames.set(i, s2);
        }
        if (oldFieldNames.equals(newFieldNames)) {
            return this;
        }
        if (this.peek() instanceof Values) {
            Values v = (Values)this.build();
            b = this.getTypeFactory().builder();
            for (Pair<String, RelDataTypeField> p : Pair.zip(newFieldNames, v.getRowType().getFieldList())) {
                ((RelDataTypeFactory.Builder)b).add((String)p.left, ((RelDataTypeField)p.right).getType());
            }
            return this.values(v.tuples, b.build());
        }
        if (this.peek() instanceof HiveUncollect) {
            HiveUncollect v = (HiveUncollect)this.build();
            b = this.getTypeFactory().builder();
            for (Pair<String, RelDataTypeField> p : Pair.zip(newFieldNames, v.getRowType().getFieldList())) {
                ((RelDataTypeFactory.Builder)b).add((String)p.left, ((RelDataTypeField)p.right).getType());
            }
            this.push(v.copy(b.build()));
            return this;
        }
        return this.project(this.fields(), newFieldNames, true);
    }
}

