/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.org.codehaus.janino;

import com.linkedin.coral.calcite.;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.Descriptor;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.IClass;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.IClassLoader;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.ReflectionIClass;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderIClassLoader
extends IClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ClassLoaderIClassLoader.class.getName());
    private final ClassLoader classLoader;

    public ClassLoaderIClassLoader(ClassLoader classLoader) {
        super(null);
        this.classLoader = classLoader;
        super.postConstruct();
    }

    public ClassLoaderIClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    @.Nullable
    protected IClass findIClass(String descriptor) throws ClassNotFoundException {
        Class<?> clazz;
        LOGGER.entering(null, "findIClass", descriptor);
        try {
            clazz = Class.forName(Descriptor.toClassName(descriptor), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            if (e.getException() == null) {
                return null;
            }
            throw e;
        }
        LOGGER.log(Level.FINE, "clazz={0}", clazz);
        ReflectionIClass result = new ReflectionIClass(clazz, this);
        this.defineIClass(result);
        return result;
    }
}

