/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.org.codehaus.janino;

import com.linkedin.coral.calcite.;
import com.linkedin.coral.calcite.$internal.org.codehaus.commons.compiler.CompileException;
import com.linkedin.coral.calcite.$internal.org.codehaus.commons.compiler.IClassBodyEvaluator;
import com.linkedin.coral.calcite.$internal.org.codehaus.commons.compiler.Location;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.InternalCompilerException;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.Parser;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.Scanner;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.SimpleCompiler;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.TokenType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class ClassBodyEvaluator
extends SimpleCompiler
implements IClassBodyEvaluator {
    private static final Class<?>[] ZERO_CLASSES = new Class[0];
    @.Nullable
    private String[] optionalDefaultImports;
    private String className = "SC";
    @.Nullable
    private Class<?> optionalExtendedType;
    private Class<?>[] implementedTypes = ZERO_CLASSES;
    @.Nullable
    private Class<?> result;

    public ClassBodyEvaluator(String classBody) throws CompileException {
        this.cook(classBody);
    }

    public ClassBodyEvaluator(@.Nullable String optionalFileName, InputStream is) throws CompileException, IOException {
        this.cook(optionalFileName, is);
    }

    public ClassBodyEvaluator(@.Nullable String optionalFileName, Reader reader) throws CompileException, IOException {
        this.cook(optionalFileName, reader);
    }

    public ClassBodyEvaluator(Scanner scanner, @.Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator(Scanner scanner, @.Nullable Class<?> optionalExtendedType, Class<?>[] implementedTypes, @.Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator(Scanner scanner, String className, @.Nullable Class<?> optionalExtendedType, Class<?>[] implementedTypes, @.Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setClassName(className);
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator() {
    }

    @Override
    public void setDefaultImports(String ... optionalDefaultImports) {
        this.optionalDefaultImports = optionalDefaultImports;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void setExtendedClass(@.Nullable Class<?> optionalExtendedType) {
        this.optionalExtendedType = optionalExtendedType;
    }

    @Override
    @Deprecated
    public void setExtendedType(@.Nullable Class<?> optionalExtendedClass) {
        this.setExtendedClass(optionalExtendedClass);
    }

    @Override
    public void setImplementedInterfaces(Class<?>[] implementedTypes) {
        this.implementedTypes = implementedTypes;
    }

    @Override
    @Deprecated
    public void setImplementedTypes(Class<?>[] implementedInterfaces) {
        this.setImplementedInterfaces(implementedInterfaces);
    }

    @Override
    public void cook(Scanner scanner) throws CompileException, IOException {
        Parser parser = new Parser(scanner);
        .Java.CompilationUnit compilationUnit = this.makeCompilationUnit(parser);
        .Java.PackageMemberClassDeclaration cd2 = this.addPackageMemberClassDeclaration(scanner.location(), compilationUnit);
        while (!parser.peek(TokenType.END_OF_INPUT)) {
            parser.parseClassBodyDeclaration(cd2);
        }
        this.result = this.compileToClass(compilationUnit);
    }

    protected final .Java.CompilationUnit makeCompilationUnit(@.Nullable Parser optionalParser) throws CompileException, IOException {
        .Java.CompilationUnit cu = new .Java.CompilationUnit(optionalParser == null ? null : optionalParser.getScanner().getFileName());
        if (this.optionalDefaultImports != null) {
            for (String defaultImport : this.optionalDefaultImports) {
                Scanner s2 = new Scanner(null, new StringReader(defaultImport));
                Parser parser2 = new Parser(s2);
                cu.addImportDeclaration(parser2.parseImportDeclarationBody());
                parser2.read(TokenType.END_OF_INPUT);
            }
        }
        if (optionalParser != null) {
            while (optionalParser.peek("import")) {
                cu.addImportDeclaration(optionalParser.parseImportDeclaration());
            }
        }
        return cu;
    }

    protected .Java.PackageMemberClassDeclaration addPackageMemberClassDeclaration(Location location, .Java.CompilationUnit compilationUnit) throws CompileException {
        String cn = this.className;
        int idx = cn.lastIndexOf(46);
        if (idx != -1) {
            compilationUnit.setPackageDeclaration(new .Java.PackageDeclaration(location, cn.substring(0, idx)));
            cn = cn.substring(idx + 1);
        }
        .Java.PackageMemberClassDeclaration tlcd = new .Java.PackageMemberClassDeclaration(location, null, new .Java.Modifiers(1), cn, null, this.optionalClassToType(location, this.optionalExtendedType), this.classesToTypes(location, this.implementedTypes));
        compilationUnit.addPackageMemberTypeDeclaration(tlcd);
        return tlcd;
    }

    protected final Class<?> compileToClass(.Java.CompilationUnit compilationUnit) throws CompileException {
        ClassLoader cl = this.compileToClassLoader(compilationUnit);
        try {
            return cl.loadClass(this.className);
        }
        catch (ClassNotFoundException ex) {
            throw new InternalCompilerException("SNO: Generated compilation unit does not declare class '" + this.className + "'", ex);
        }
    }

    @Override
    public Class<?> getClazz() {
        if (this.getClass() != ClassBodyEvaluator.class) {
            throw new IllegalStateException("Must not be called on derived instances");
        }
        return this.assertCooked();
    }

    private Class<?> assertCooked() {
        if (this.result != null) {
            return this.result;
        }
        throw new IllegalStateException("Must only be called after 'cook()'");
    }

    @Override
    public Object createInstance(Reader reader) throws CompileException, IOException {
        this.cook(reader);
        try {
            return this.getClazz().newInstance();
        }
        catch (InstantiationException ie) {
            CompileException ce = new CompileException("Class is abstract, an interface, an array class, a primitive type, or void; or has no zero-parameter constructor", null);
            ce.initCause(ie);
            throw ce;
        }
        catch (IllegalAccessException iae) {
            CompileException ce = new CompileException("The class or its zero-parameter constructor is not accessible", null);
            ce.initCause(iae);
            throw ce;
        }
    }

    public static Object createFastClassBodyEvaluator(Scanner scanner, @.Nullable Class<?> optionalBaseType, @.Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        Class[] classArray;
        Class<?> clazz = optionalBaseType != null && !optionalBaseType.isInterface() ? optionalBaseType : null;
        if (optionalBaseType != null && optionalBaseType.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = optionalBaseType;
        } else {
            classArray = new Class[]{};
        }
        return ClassBodyEvaluator.createFastClassBodyEvaluator(scanner, "SC", clazz, classArray, optionalParentClassLoader);
    }

    @Deprecated
    public static Object createFastClassBodyEvaluator(Scanner scanner, String className, @.Nullable Class<?> optionalExtendedClass, Class<?>[] implementedInterfaces, @.Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ClassBodyEvaluator cbe = new ClassBodyEvaluator();
        cbe.setClassName(className);
        cbe.setExtendedClass(optionalExtendedClass);
        cbe.setImplementedInterfaces(implementedInterfaces);
        cbe.setParentClassLoader(optionalParentClassLoader);
        cbe.cook(scanner);
        Class<?> c = cbe.getClazz();
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new CompileException(e.getMessage(), null);
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerException(e.toString(), e);
        }
    }
}

