/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple;

import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.BinomialBoundsN;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.SketchIterator;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.Summary;

public abstract class Sketch<S extends Summary> {
    protected static final byte PREAMBLE_LONGS = 1;
    long[] keys_;
    S[] summaries_;
    long theta_;
    boolean isEmpty_ = true;

    Sketch() {
    }

    public double getEstimate() {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return (double)this.getRetainedEntries() / this.getTheta();
    }

    public double getUpperBound(int numStdDev) {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return BinomialBoundsN.getUpperBound(this.getRetainedEntries(), this.getTheta(), numStdDev, this.isEmpty_);
    }

    public double getLowerBound(int numStdDev) {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return BinomialBoundsN.getLowerBound(this.getRetainedEntries(), this.getTheta(), numStdDev, this.isEmpty_);
    }

    public boolean isEmpty() {
        return this.isEmpty_;
    }

    public boolean isEstimationMode() {
        return this.theta_ < Long.MAX_VALUE && !this.isEmpty();
    }

    public abstract int getRetainedEntries();

    public double getTheta() {
        return (double)this.theta_ / 9.223372036854776E18;
    }

    public abstract S[] getSummaries();

    public abstract byte[] toByteArray();

    public SketchIterator<S> iterator() {
        return new SketchIterator(this.keys_, this.summaries_);
    }

    long getThetaLong() {
        return this.theta_;
    }
}

