/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.HashOperations;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesAnotB;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.DirectArrayOfDoublesCompactSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.HeapArrayOfDoublesCompactSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.Util;
import java.util.Arrays;

final class HeapArrayOfDoublesAnotB
extends ArrayOfDoublesAnotB {
    private boolean isEmpty_ = true;
    private long theta_ = Long.MAX_VALUE;
    private long[] keys_;
    private double[] values_;
    private int count_;
    private final short seedHash_;
    private final int numValues_;

    HeapArrayOfDoublesAnotB(int numValues, long seed) {
        this.numValues_ = numValues;
        this.seedHash_ = Util.computeSeedHash(seed);
    }

    @Override
    public void update(ArrayOfDoublesSketch a, ArrayOfDoublesSketch b) {
        if (a != null) {
            Util.checkSeedHashes(this.seedHash_, a.getSeedHash());
        }
        if (b != null) {
            Util.checkSeedHashes(this.seedHash_, b.getSeedHash());
        }
        if (a != null) {
            this.isEmpty_ = a.isEmpty();
        }
        long thetaA = a == null ? Long.MAX_VALUE : a.getThetaLong();
        long thetaB = b == null ? Long.MAX_VALUE : b.getThetaLong();
        this.theta_ = Math.min(thetaA, thetaB);
        if (a == null || a.getRetainedEntries() == 0) {
            return;
        }
        if (b == null || b.getRetainedEntries() == 0) {
            this.getNoMatchSetFromSketch(a);
        } else {
            long[] hashTable = HeapArrayOfDoublesAnotB.convertToHashTable(b);
            int lgHashTableSize = Integer.numberOfTrailingZeros(hashTable.length);
            int noMatchSize = a.getRetainedEntries();
            this.keys_ = new long[noMatchSize];
            this.values_ = new double[noMatchSize * this.numValues_];
            ArrayOfDoublesSketchIterator it = a.iterator();
            while (it.next()) {
                int index = HashOperations.hashSearch(hashTable, lgHashTableSize, it.getKey());
                if (index != -1) continue;
                this.keys_[this.count_] = it.getKey();
                System.arraycopy(it.getValues(), 0, this.values_, this.count_ * this.numValues_, this.numValues_);
                ++this.count_;
            }
        }
    }

    @Override
    public ArrayOfDoublesCompactSketch getResult() {
        if (this.count_ == 0) {
            return new HeapArrayOfDoublesCompactSketch(null, null, Long.MAX_VALUE, true, this.numValues_, this.seedHash_);
        }
        HeapArrayOfDoublesCompactSketch result = new HeapArrayOfDoublesCompactSketch(Arrays.copyOfRange(this.keys_, 0, this.count_), Arrays.copyOfRange(this.values_, 0, this.count_ * this.numValues_), this.theta_, this.isEmpty_, this.numValues_, this.seedHash_);
        this.reset();
        return result;
    }

    @Override
    public ArrayOfDoublesCompactSketch getResult(Memory mem) {
        if (mem == null || this.count_ == 0) {
            return this.getResult();
        }
        DirectArrayOfDoublesCompactSketch result = new DirectArrayOfDoublesCompactSketch(Arrays.copyOfRange(this.keys_, 0, this.count_), Arrays.copyOfRange(this.values_, 0, this.count_ * this.numValues_), this.theta_, this.isEmpty_, this.numValues_, this.seedHash_, mem);
        this.reset();
        return result;
    }

    private static long[] convertToHashTable(ArrayOfDoublesSketch sketch) {
        int size = Math.max(com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Util.ceilingPowerOf2((int)Math.ceil((double)sketch.getRetainedEntries() / 0.9375)), 16);
        long[] hashTable = new long[size];
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        int lgSize = Integer.numberOfTrailingZeros(size);
        while (it.next()) {
            HashOperations.hashInsertOnly(hashTable, lgSize, it.getKey());
        }
        return hashTable;
    }

    private void reset() {
        this.isEmpty_ = true;
        this.theta_ = Long.MAX_VALUE;
        this.keys_ = null;
        this.values_ = null;
        this.count_ = 0;
    }

    private void getNoMatchSetFromSketch(ArrayOfDoublesSketch sketch) {
        this.count_ = sketch.getRetainedEntries();
        this.keys_ = new long[this.count_];
        this.values_ = new double[this.count_ * this.numValues_];
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        int i = 0;
        while (it.next()) {
            this.keys_[i] = it.getKey();
            System.arraycopy(it.getValues(), 0, this.values_, i * this.numValues_, this.numValues_);
            ++i;
        }
    }
}

