/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.NativeMemory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Family;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.HashOperations;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.ResizeFactor;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.SketchesArgumentException;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesQuickSelectSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.DirectArrayOfDoublesSketchIterator;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.SerializerDeserializer;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.Util;
import java.nio.ByteOrder;
import java.util.Arrays;

final class DirectArrayOfDoublesQuickSelectSketch
extends ArrayOfDoublesQuickSelectSketch {
    private Memory mem_;
    private int keysOffset_;
    private int valuesOffset_;

    DirectArrayOfDoublesQuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, int numValues, long seed, Memory dstMem) {
        super(numValues, seed);
        this.mem_ = dstMem;
        int startingCapacity = 1 << com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Util.startingSubMultiple(Integer.numberOfTrailingZeros(com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Util.ceilingPowerOf2(nomEntries) * 2), ResizeFactor.getRF(lgResizeFactor), 5);
        DirectArrayOfDoublesQuickSelectSketch.checkIfEnoughMemory(dstMem, startingCapacity, numValues);
        this.mem_.putByte(0L, (byte)1);
        this.mem_.putByte(1L, (byte)1);
        this.mem_.putByte(2L, (byte)Family.TUPLE.getID());
        this.mem_.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.mem_.putByte(4L, (byte)((isBigEndian ? 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() : 0) | (samplingProbability < 1.0f ? 1 << ArrayOfDoublesSketch.Flags.IS_IN_SAMPLING_MODE.ordinal() : 0) | 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()));
        this.mem_.putByte(5L, (byte)numValues);
        this.mem_.putShort(6L, Util.computeSeedHash(seed));
        this.theta_ = (long)(9.223372036854776E18 * (double)samplingProbability);
        this.mem_.putLong(8L, this.theta_);
        this.mem_.putByte(16L, (byte)Integer.numberOfTrailingZeros(nomEntries));
        this.mem_.putByte(17L, (byte)Integer.numberOfTrailingZeros(startingCapacity));
        this.mem_.putByte(18L, (byte)lgResizeFactor);
        this.mem_.putFloat(20L, samplingProbability);
        this.mem_.putInt(24L, 0);
        this.keysOffset_ = 32;
        this.valuesOffset_ = this.keysOffset_ + 8 * startingCapacity;
        this.mem_.clear(this.keysOffset_, 8 * startingCapacity);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.setRebuildThreshold();
    }

    DirectArrayOfDoublesQuickSelectSketch(Memory mem, long seed) {
        super(mem.getByte(5L), seed);
        this.mem_ = mem;
        SerializerDeserializer.validateFamily(mem.getByte(2L), mem.getByte(0L));
        SerializerDeserializer.validateType(this.mem_.getByte(3L), SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch);
        byte version = this.mem_.getByte(1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        boolean isBigEndian = mem.isAllBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal()));
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        Util.checkSeedHashes(mem.getShort(6L), Util.computeSeedHash(seed));
        this.keysOffset_ = 32;
        this.valuesOffset_ = this.keysOffset_ + 8 * this.getCurrentCapacity();
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(this.getCurrentCapacity());
        this.theta_ = this.mem_.getLong(8L);
        this.isEmpty_ = this.mem_.isAllBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()));
        this.setRebuildThreshold();
    }

    @Override
    public double[][] getValues() {
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            long keyOffset = this.keysOffset_;
            long valuesOffset = this.valuesOffset_;
            int i = 0;
            for (int j = 0; j < this.getCurrentCapacity(); ++j) {
                if (this.mem_.getLong(keyOffset) != 0L) {
                    double[] array = new double[this.numValues_];
                    this.mem_.getDoubleArray(valuesOffset, array, 0, this.numValues_);
                    values[i++] = array;
                }
                keyOffset += 8L;
                valuesOffset += 8L * (long)this.numValues_;
            }
        }
        return values;
    }

    @Override
    public int getRetainedEntries() {
        return this.mem_.getInt(24L);
    }

    @Override
    public int getNominalEntries() {
        return 1 << this.mem_.getByte(16L);
    }

    @Override
    public byte[] toByteArray() {
        int sizeBytes = this.valuesOffset_ + 8 * this.numValues_ * this.getCurrentCapacity();
        byte[] byteArray = new byte[sizeBytes];
        NativeMemory mem = new NativeMemory(byteArray);
        this.mem_.copy(0L, mem, 0L, sizeBytes);
        return byteArray;
    }

    @Override
    protected long getKey(int index) {
        return this.mem_.getLong(this.keysOffset_ + 8 * index);
    }

    @Override
    protected void incrementCount() {
        int count = this.mem_.getInt(24L);
        if (count == 0) {
            this.mem_.setBits(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()));
        }
        this.mem_.putInt(24L, count + 1);
    }

    @Override
    protected int getCurrentCapacity() {
        return 1 << this.mem_.getByte(17L);
    }

    @Override
    protected void setThetaLong(long theta) {
        this.theta_ = theta;
        this.mem_.putLong(8L, this.theta_);
    }

    @Override
    protected int getResizeFactor() {
        return 1 << this.mem_.getByte(18L);
    }

    @Override
    protected void setValues(int index, double[] values) {
        long offset = this.valuesOffset_ + 8 * this.numValues_ * index;
        for (int i = 0; i < this.numValues_; ++i) {
            this.mem_.putDouble(offset, values[i]);
            offset += 8L;
        }
    }

    @Override
    protected void updateValues(int index, double[] values) {
        long offset = this.valuesOffset_ + 8 * this.numValues_ * index;
        for (int i = 0; i < this.numValues_; ++i) {
            this.mem_.putDouble(offset, this.mem_.getDouble(offset) + values[i]);
            offset += 8L;
        }
    }

    @Override
    protected void setNotEmpty() {
        if (this.isEmpty_) {
            this.isEmpty_ = false;
            this.mem_.clearBits(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()));
        }
    }

    @Override
    protected boolean isInSamplingMode() {
        return this.mem_.isAnyBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_IN_SAMPLING_MODE.ordinal()));
    }

    @Override
    protected void rebuild(int newCapacity) {
        int numValues = this.getNumValues();
        DirectArrayOfDoublesQuickSelectSketch.checkIfEnoughMemory(this.mem_, newCapacity, numValues);
        int currCapacity = this.getCurrentCapacity();
        long[] keys = new long[currCapacity];
        double[] values = new double[currCapacity * numValues];
        this.mem_.getLongArray(this.keysOffset_, keys, 0, currCapacity);
        this.mem_.getDoubleArray(this.valuesOffset_, values, 0, currCapacity * numValues);
        this.mem_.clear(this.keysOffset_, 8 * newCapacity + 8 * newCapacity * numValues);
        this.mem_.putInt(24L, 0);
        this.mem_.putByte(17L, (byte)Integer.numberOfTrailingZeros(newCapacity));
        this.valuesOffset_ = this.keysOffset_ + 8 * newCapacity;
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(newCapacity);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == 0L || keys[i] >= this.theta_) continue;
            this.insert(keys[i], Arrays.copyOfRange(values, i * numValues, (i + 1) * numValues));
        }
        this.setRebuildThreshold();
    }

    @Override
    protected int insertKey(long key) {
        return HashOperations.hashInsertOnly(this.mem_, this.lgCurrentCapacity_, key, 32);
    }

    @Override
    protected int findOrInsertKey(long key) {
        return HashOperations.hashSearchOrInsert(this.mem_, this.lgCurrentCapacity_, key, 32);
    }

    @Override
    protected double[] find(long key) {
        int index = HashOperations.hashSearch(this.mem_, this.lgCurrentCapacity_, key, 32);
        if (index == -1) {
            return null;
        }
        double[] array = new double[this.numValues_];
        this.mem_.getDoubleArray(this.valuesOffset_ + 8 * this.numValues_ * index, array, 0, this.numValues_);
        return array;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new DirectArrayOfDoublesSketchIterator(this.mem_, this.keysOffset_, this.getCurrentCapacity(), this.numValues_);
    }

    private static void checkIfEnoughMemory(Memory mem, int numEntries, int numValues) {
        int sizeNeeded = 32 + (8 + 8 * numValues) * numEntries;
        if ((long)sizeNeeded > mem.getCapacity()) {
            throw new SketchesArgumentException("Not enough memory: need " + sizeNeeded + " bytes, got " + mem.getCapacity() + " bytes");
        }
    }
}

