/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles;

import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.SketchesArgumentException;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.ItemsSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.ItemsUpdateImpl;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;
import java.util.Comparator;

final class ItemsUtil {
    static final int ITEMS_SER_VER = 3;
    static final int PRIOR_ITEMS_SER_VER = 2;

    private ItemsUtil() {
    }

    static void checkItemsSerVer(int serVer) {
        if (serVer == 3 || serVer == 2) {
            return;
        }
        throw new SketchesArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
    }

    static final <T> void validateValues(T[] values, Comparator<? super T> comparator) {
        int lenM1 = values.length - 1;
        for (int j = 0; j < lenM1; ++j) {
            if (values[j] != null && values[j + 1] != null && comparator.compare(values[j], values[j + 1]) < 0) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not null.");
        }
    }

    static <T> void processFullBaseBuffer(ItemsSketch<T> sketch) {
        int bbCount = sketch.getBaseBufferCount();
        long n = sketch.getN();
        assert (bbCount == 2 * sketch.getK());
        ItemsUpdateImpl.maybeGrowLevels(sketch, n);
        Object[] baseBuffer = sketch.getCombinedBuffer();
        Arrays.sort(baseBuffer, 0, bbCount);
        ItemsUpdateImpl.inPlacePropagateCarry(0, null, 0, baseBuffer, 0, true, sketch);
        sketch.baseBufferCount_ = 0;
        Arrays.fill(baseBuffer, 0, 2 * sketch.getK(), null);
        assert (n / (long)(2 * sketch.getK()) == sketch.getBitPattern());
    }

    static <T> String toString(boolean sketchSummary, boolean dataDetail, ItemsSketch<T> sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        int bbCount = sketch.getBaseBufferCount();
        int combAllocCount = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        long bitPattern = sketch.getBitPattern();
        if (dataDetail) {
            sb.append(Util.LS).append("### ").append(thisSimpleName).append(" DATA DETAIL: ").append(Util.LS);
            Object[] items = sketch.getCombinedBuffer();
            sb.append("   BaseBuffer   :");
            if (bbCount > 0) {
                for (int i = 0; i < bbCount; ++i) {
                    sb.append(' ').append(items[i]);
                }
            }
            sb.append(Util.LS);
            int numItems = combAllocCount;
            if (numItems > 2 * k) {
                sb.append("   Valid | Level");
                for (int j = 2 * k; j < numItems; ++j) {
                    if (j % k == 0) {
                        int levelNum = j > 2 * k ? (j - 2 * k) / k : 0;
                        String validLvl = (1L << levelNum & bitPattern) > 0L ? "    T  " : "    F  ";
                        String lvl = String.format("%5d", levelNum);
                        sb.append(Util.LS).append("   ").append(validLvl).append(" ").append(lvl).append(":");
                    }
                    sb.append(' ').append(items[j]);
                }
                sb.append(Util.LS);
            }
            sb.append("### END DATA DETAIL").append(Util.LS);
        }
        if (sketchSummary) {
            long n = sketch.getN();
            String nStr = String.format("%,d", n);
            int numLevels = Util.computeNumLevelsNeeded(k, n);
            String bufCntStr = String.format("%,d", combAllocCount);
            int preBytes = sketch.isEmpty() ? 8 : 16;
            double eps = Util.EpsilonFromK.getAdjustedEpsilon(k);
            String epsPct = String.format("%.3f%%", eps * 100.0);
            int numSamples = sketch.getRetainedItems();
            String numSampStr = String.format("%,d", numSamples);
            sb.append(Util.LS).append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
            sb.append("   K                            : ").append(k).append(Util.LS);
            sb.append("   N                            : ").append(nStr).append(Util.LS);
            sb.append("   BaseBufferCount              : ").append(bbCount).append(Util.LS);
            sb.append("   CombinedBufferAllocatedCount : ").append(bufCntStr).append(Util.LS);
            sb.append("   Total Levels                 : ").append(numLevels).append(Util.LS);
            sb.append("   Valid Levels                 : ").append(Util.computeValidLevels(bitPattern)).append(Util.LS);
            sb.append("   Level Bit Pattern            : ").append(Long.toBinaryString(bitPattern)).append(Util.LS);
            sb.append("   Valid Samples                : ").append(numSampStr).append(Util.LS);
            sb.append("   Preamble Bytes               : ").append(preBytes).append(Util.LS);
            sb.append("   Normalized Rank Error        : ").append(epsPct).append(Util.LS);
            sb.append("   Min Value                    : ").append(sketch.getMinValue()).append(Util.LS);
            sb.append("   Max Value                    : ").append(sketch.getMaxValue()).append(Util.LS);
            sb.append("### END SKETCH SUMMARY").append(Util.LS);
        }
        return sb.toString();
    }
}

