/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.memory;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.MemoryRequest;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.NativeMemory;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.UnsafeUtil;
import sun.misc.Cleaner;

public class AllocMemory
extends NativeMemory {
    private final Cleaner cleaner;

    public AllocMemory(long capacityBytes) {
        this(capacityBytes, null);
    }

    public AllocMemory(long capacityBytes, MemoryRequest memReq) {
        super(UnsafeUtil.unsafe.allocateMemory(capacityBytes), capacityBytes, 0L, null, null);
        this.memReq_ = memReq;
        this.cleaner = Cleaner.create((Object)this, (Runnable)new Deallocator(this.nativeBaseAddress_));
    }

    public AllocMemory(NativeMemory origMem, long newCapacityBytes, MemoryRequest memReq) {
        this(origMem, origMem.getCapacity(), newCapacityBytes, false, memReq);
    }

    public AllocMemory(NativeMemory origMem, long copyToBytes, long capacityBytes, boolean clear, MemoryRequest memReq) {
        this(capacityBytes, memReq);
        origMem.copy(0L, this, 0L, copyToBytes);
        if (clear) {
            this.clear(copyToBytes, capacityBytes - copyToBytes);
        }
    }

    @Override
    public void freeMemory() {
        this.cleaner.clean();
        super.freeMemory();
    }

    private static final class Deallocator
    implements Runnable {
        private long nativeBaseAddress_;

        private Deallocator(long nativeBaseAddress) {
            assert (nativeBaseAddress != 0L);
            this.nativeBaseAddress_ = nativeBaseAddress;
        }

        @Override
        public void run() {
            if (this.nativeBaseAddress_ == 0L) {
                return;
            }
            UnsafeUtil.unsafe.freeMemory(this.nativeBaseAddress_);
        }
    }
}

