/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.io;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configurable;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Writable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.WritableFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@.InterfaceAudience.Public
@.InterfaceStability.Stable
public class WritableFactories {
    private static final Map<Class, WritableFactory> CLASS_TO_FACTORY = new ConcurrentHashMap<Class, WritableFactory>();

    private WritableFactories() {
    }

    public static void setFactory(Class c, WritableFactory factory) {
        CLASS_TO_FACTORY.put(c, factory);
    }

    public static WritableFactory getFactory(Class c) {
        return CLASS_TO_FACTORY.get(c);
    }

    public static Writable newInstance(Class<? extends Writable> c, Configuration conf) {
        WritableFactory factory = WritableFactories.getFactory(c);
        if (factory != null) {
            Writable result = factory.newInstance();
            if (result instanceof Configurable) {
                ((Configurable)((Object)result)).setConf(conf);
            }
            return result;
        }
        return (Writable).ReflectionUtils.newInstance(c, (Configuration)conf);
    }

    public static Writable newInstance(Class<? extends Writable> c) {
        return WritableFactories.newInstance(c, null);
    }
}

