/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.io.LongWritable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hive.common.util.HiveStringUtils;

public class LazyLong
extends LazyPrimitive<LazyLongObjectInspector, LongWritable> {
    public LazyLong(LazyLongObjectInspector oi) {
        super(oi);
        this.data = new LongWritable();
    }

    public LazyLong(LazyLong copy) {
        super(copy);
        this.data = new LongWritable(((LongWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (!LazyUtils.isNumberMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            ((LongWritable)this.data).set(LazyLong.parseLong(bytes.getData(), start, length, 10));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "BIGINT");
        }
    }

    public static long parseLong(byte[] bytes, int start, int length) {
        return LazyLong.parseLong(bytes, start, length, 10);
    }

    public static long parseLong(byte[] bytes, int start, int length, int radix) {
        return LazyLong.parseLong(bytes, start, length, radix, false);
    }

    public static long parseLong(byte[] bytes, int start, int length, int radix, boolean trim) {
        boolean negative;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (trim) {
            int leadingSpaces = HiveStringUtils.findLeadingSpaces((byte[])bytes, (int)start, (int)length);
            int trailingSpaces = HiveStringUtils.findTrailingSpaces((byte[])bytes, (int)start, (int)length);
            start += leadingSpaces;
            length -= Math.min(length, leadingSpaces + trailingSpaces);
        }
        if (length == 0) {
            throw new NumberFormatException("Empty string!");
        }
        int offset = start;
        boolean bl = negative = bytes[start] == 45;
        if (negative || bytes[start] == 43) {
            ++offset;
            if (length == 1) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
        }
        return LazyLong.parse(bytes, start, length, offset, radix, negative);
    }

    private static long parse(byte[] bytes, int start, int length, int offset, int radix, boolean negative) {
        int digit;
        byte separator = 46;
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        long end = start + length;
        while ((long)offset < end) {
            if ((digit = LazyUtils.digit(bytes[offset++], radix)) == -1 || max > result) {
                if (bytes[offset - 1] == separator) break;
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
            result = next;
        }
        while ((long)offset < end) {
            if ((digit = LazyUtils.digit(bytes[offset++], radix)) != -1) continue;
            throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
        }
        if (!negative && (result = -result) < 0L) {
            throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
        }
        return result;
    }

    public static void writeUTF8(OutputStream out, long i) throws IOException {
        boolean negative;
        if (i == 0L) {
            out.write(48);
            return;
        }
        boolean bl = negative = i < 0L;
        if (negative) {
            out.write(45);
        } else {
            i = -i;
        }
        long start = 1000000000000000000L;
        while (i / start == 0L) {
            start /= 10L;
        }
        while (start > 0L) {
            out.write(48 - (int)(i / start % 10L));
            start /= 10L;
        }
    }

    public static void writeUTF8NoException(OutputStream out, long i) {
        try {
            LazyLong.writeUTF8(out, i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

