/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io;

import com.linkedin.coral.$internal.org.apache.hadoop.io.WritableComparable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ShortWritable
implements WritableComparable {
    private short value;

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readShort();
    }

    public ShortWritable(short s2) {
        this.value = s2;
    }

    public ShortWritable() {
        this.value = 0;
    }

    public void set(short value) {
        this.value = value;
    }

    public short get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ShortWritable.class) {
            return false;
        }
        return this.get() == ((ShortWritable)o).get();
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    @Override
    public int compareTo(Object o) {
        short thisValue = this.value;
        short thatValue = ((ShortWritable)o).value;
        return thisValue - thatValue;
    }

    static {
        WritableComparator.define(ShortWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(ShortWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            short a1 = (short)Comparator.readUnsignedShort(b1, s1);
            short a2 = (short)Comparator.readUnsignedShort(b2, s2);
            return a1 - a2;
        }
    }
}

