/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2;

import com.linkedin.coral.;
import java.io.IOException;
import java.util.Arrays;

public class ByteStream {

    public static interface RandomAccessOutput {
        public void writeByte(long var1, byte var3);

        public void writeInt(long var1, int var3);

        public void reserve(int var1);

        public void write(int var1);

        public void write(byte[] var1) throws IOException;

        public void write(byte[] var1, int var2, int var3);

        public int getLength();
    }

    public static final class Output
    extends .NonSyncByteArrayOutputStream
    implements RandomAccessOutput {
        private static final byte[] RESERVE_INT = new byte[]{0, 0, 0, 0};

        public Output() {
        }

        public Output(int size) {
            super(size);
        }

        public byte[] getData() {
            return this.buf;
        }

        @Override
        public void writeInt(long offset, int value) {
            int i = (int)offset;
            this.buf[i + 0] = (byte)(value >> 24);
            this.buf[i + 1] = (byte)(value >> 16);
            this.buf[i + 2] = (byte)(value >> 8);
            this.buf[i + 3] = (byte)value;
        }

        @Override
        public void writeByte(long offset, byte value) {
            this.buf[(int)offset] = value;
        }

        @Override
        public void reserve(int byteCount) {
            switch (byteCount) {
                case 0: {
                    break;
                }
                case 1: {
                    this.write(0);
                    break;
                }
                case 4: {
                    this.write(RESERVE_INT, 0, 4);
                    break;
                }
                default: {
                    for (int i = 0; i < byteCount; ++i) {
                        this.write(0);
                    }
                }
            }
        }

        public boolean arraysEquals(Output output) {
            return Arrays.equals(this.buf, output.buf);
        }
    }

    public static class Input
    extends .NonSyncByteArrayInputStream {
        public Input() {
        }

        public Input(byte[] buf) {
            super(buf);
        }

        public byte[] getData() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }

        public void reset(byte[] buf, int count) {
            this.buf = buf;
            this.count = count;
            this.pos = 0;
            this.mark = 0;
        }

        public Input(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }
    }
}

