/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.DataType;
import com.linkedin.coral.$internal.io.trino.sql.tree.DataTypeParameter;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TypeParameter
extends DataTypeParameter {
    private final DataType type;

    public TypeParameter(DataType type) {
        super(Optional.empty());
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public DataType getValue() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of(this.type);
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTypeParameter(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParameter that = (TypeParameter)o;
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return TypeParameter.sameClass(this, other);
    }
}

