/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Identifier;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.SelectItem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SingleColumn
extends SelectItem {
    private final Optional<Identifier> alias;
    private final Expression expression;

    public SingleColumn(Expression expression) {
        this(Optional.empty(), expression, Optional.empty());
    }

    public SingleColumn(Expression expression, Optional<Identifier> alias) {
        this(Optional.empty(), expression, alias);
    }

    public SingleColumn(Expression expression, Identifier alias) {
        this(Optional.empty(), expression, Optional.of(alias));
    }

    public SingleColumn(NodeLocation location, Expression expression, Optional<Identifier> alias) {
        this(Optional.of(location), expression, alias);
    }

    private SingleColumn(Optional<NodeLocation> location, Expression expression, Optional<Identifier> alias) {
        super(location);
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(alias, "alias is null");
        this.expression = expression;
        this.alias = alias;
    }

    public Optional<Identifier> getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleColumn other = (SingleColumn)obj;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.expression, other.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alias, this.expression);
    }

    @Override
    public String toString() {
        if (this.alias.isPresent()) {
            return this.expression.toString() + " " + this.alias.get();
        }
        return this.expression.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.expression);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!SingleColumn.sameClass(this, other)) {
            return false;
        }
        return this.alias.equals(((SingleColumn)other).alias);
    }
}

