/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.DataType;
import com.linkedin.coral.$internal.io.trino.sql.tree.Identifier;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowDataType
extends DataType {
    private final List<Field> fields;

    public RowDataType(NodeLocation location, List<Field> fields) {
        super(Optional.of(location));
        this.fields = ImmutableList.copyOf(fields);
    }

    public RowDataType(Optional<NodeLocation> location, List<Field> fields) {
        super(location);
        this.fields = ImmutableList.copyOf(fields);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.fields;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRowDataType(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowDataType that = (RowDataType)o;
        return this.fields.equals(that.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fields);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return RowDataType.sameClass(this, other);
    }

    public static class Field
    extends Node {
        private final Optional<Identifier> name;
        private final DataType type;

        public Field(NodeLocation location, Optional<Identifier> name, DataType type) {
            super(Optional.of(location));
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public Field(Optional<NodeLocation> location, Optional<Identifier> name, DataType type) {
            super(location);
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public Optional<Identifier> getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        @Override
        public List<? extends Node> getChildren() {
            ImmutableList.Builder children = ImmutableList.builder();
            this.name.ifPresent(children::add);
            children.add(this.type);
            return children.build();
        }

        @Override
        protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
            return visitor.visitRowField(this, context);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.name.isPresent()) {
                builder.append(this.name.get());
                builder.append(" ");
            }
            builder.append(this.type);
            return builder.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return this.name.equals(field.name) && this.type.equals(field.type);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        @Override
        public boolean shallowEquals(Node other) {
            return Field.sameClass(this, other);
        }
    }
}

