/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.Joiner;
import com.linkedin.coral.$internal.com.google.common.base.Preconditions;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.com.google.common.collect.Iterables;
import com.linkedin.coral.$internal.com.google.common.collect.Lists;
import com.linkedin.coral.$internal.io.trino.sql.tree.Identifier;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class QualifiedName {
    private final List<String> parts;
    private final List<Identifier> originalParts;

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first, "first is null");
        return QualifiedName.of(ImmutableList.copyOf(Lists.asList(first, rest).stream().map(Identifier::new).collect(Collectors.toList())));
    }

    public static QualifiedName of(String name) {
        Objects.requireNonNull(name, "name is null");
        return QualifiedName.of(ImmutableList.of(new Identifier(name)));
    }

    public static QualifiedName of(Iterable<Identifier> originalParts) {
        Objects.requireNonNull(originalParts, "originalParts is null");
        Preconditions.checkArgument(!Iterables.isEmpty(originalParts), "originalParts is empty");
        return new QualifiedName(ImmutableList.copyOf(originalParts));
    }

    private QualifiedName(List<Identifier> originalParts) {
        this.originalParts = originalParts;
        this.parts = originalParts.stream().map(identifier -> identifier.getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }

    public List<String> getParts() {
        return this.parts;
    }

    public List<Identifier> getOriginalParts() {
        return this.originalParts;
    }

    public String toString() {
        return Joiner.on('.').join(this.parts);
    }

    public Optional<QualifiedName> getPrefix() {
        if (this.parts.size() == 1) {
            return Optional.empty();
        }
        List<Identifier> subList = this.originalParts.subList(0, this.originalParts.size() - 1);
        return Optional.of(new QualifiedName(subList));
    }

    public boolean hasSuffix(QualifiedName suffix) {
        if (this.parts.size() < suffix.getParts().size()) {
            return false;
        }
        int start = this.parts.size() - suffix.getParts().size();
        return this.parts.subList(start, this.parts.size()).equals(suffix.getParts());
    }

    public String getSuffix() {
        return Iterables.getLast(this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.parts.equals(((QualifiedName)o).parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

